/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.determination;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ConversationDeterminationTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConversationDeterminationTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="conversation_context", id="da"), @SpecAssertion(section="conversation_context", id="db"), @SpecAssertion(section="conversation_context", id="dc"), @SpecAssertion(section="conversation_context", id="dd")})
    public void testConversationDetermination() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage cidPage = (TextPage)webClient.getPage(this.contextPath + "foo?action=begin");
        String cid = cidPage.getContent().substring(cidPage.getContent().indexOf("cid: [") + 6, cidPage.getContent().indexOf("]"));
        Assert.assertTrue((boolean)cidPage.getContent().contains("transient: false"));
        TextPage resultPage = (TextPage)webClient.getPage(this.contextPath + "foo?action=test&cid=" + cid.trim());
        Assert.assertTrue((boolean)resultPage.getContent().contains("testServlet=true"));
        Assert.assertTrue((boolean)resultPage.getContent().contains("testFilter=true"));
        Assert.assertTrue((boolean)resultPage.getContent().contains("testListener=true"));
        resultPage = (TextPage)webClient.getPage(this.contextPath + "foo-async?action=test&cid=" + cid.trim());
        Assert.assertTrue((boolean)resultPage.getContent().contains("testAsyncListener=true"));
    }
}

