/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.servlet;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class ServletConversationTest
extends AbstractTest {
    @ArquillianResource
    private URL url;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ServletConversationTest.class)).withWebResource("message.html", "message.html")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="conversation_context", id="aa")})
    public void testTransientConversation() throws Exception {
        WebClient client = new WebClient();
        TextPage page = (TextPage)client.getPage(this.getPath("/display", null));
        Assert.assertTrue((boolean)page.getContent().contains("message: Hello"));
        Assert.assertTrue((boolean)page.getContent().contains("cid: [null]"));
        Assert.assertTrue((boolean)page.getContent().contains("transient: true"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="conversation_context", id="aa")})
    public void testLongRunningConversation() throws Exception {
        WebClient client = new WebClient();
        TextPage initialPage = (TextPage)client.getPage(this.getPath("/begin", null));
        String content = initialPage.getContent();
        Assert.assertTrue((boolean)content.contains("message: Hello"));
        Assert.assertTrue((boolean)content.contains("transient: false"));
        String cid = this.getCid(content);
        TextPage page = (TextPage)client.getPage(this.getPath("/display", cid));
        Assert.assertTrue((boolean)page.getContent().contains("message: Hello"));
        Assert.assertTrue((boolean)page.getContent().contains("cid: [" + cid + "]"));
        Assert.assertTrue((boolean)page.getContent().contains("transient: false"));
        page = (TextPage)client.getPage(this.getPath("/set", cid) + "&message=Hi");
        Assert.assertTrue((boolean)page.getContent().contains("message: Hi"));
        Assert.assertTrue((boolean)page.getContent().contains("cid: [" + cid + "]"));
        Assert.assertTrue((boolean)page.getContent().contains("transient: false"));
        page = (TextPage)client.getPage(this.getPath("/display", cid));
        Assert.assertTrue((boolean)page.getContent().contains("message: Hi"));
        Assert.assertTrue((boolean)page.getContent().contains("cid: [" + cid + "]"));
        Assert.assertTrue((boolean)page.getContent().contains("transient: false"));
        page = (TextPage)client.getPage(this.getPath("/end", cid));
        Assert.assertTrue((boolean)page.getContent().contains("message: Hi"));
        Assert.assertTrue((boolean)page.getContent().contains("transient: true"));
        client.setThrowExceptionOnFailingStatusCode(false);
        page = client.getPage(this.getPath("/display", cid));
        Assert.assertEquals((int)page.getWebResponse().getStatusCode(), (int)500);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="conversation_context", id="aa")})
    public void testPost() throws Exception {
        WebClient client = new WebClient();
        TextPage initialPage = (TextPage)client.getPage(this.getPath("/begin", null));
        String content = initialPage.getContent();
        Assert.assertTrue((boolean)content.contains("message: Hello"));
        Assert.assertTrue((boolean)content.contains("transient: false"));
        String cid = this.getCid(content);
        HtmlPage form = (HtmlPage)client.getPage(this.url.toString() + "/message.html");
        this.getFirstMatchingElement(form, HtmlTextInput.class, "message").setValueAttribute("Hola!");
        this.getFirstMatchingElement(form, HtmlTextInput.class, "cid").setValueAttribute(cid);
        TextPage page = (TextPage)this.getFirstMatchingElement(form, HtmlSubmitInput.class, "submit").click();
        Assert.assertTrue((boolean)page.getContent().contains("message: Hola!"));
        Assert.assertTrue((boolean)page.getContent().contains("cid: [" + cid + "]"));
        Assert.assertTrue((boolean)page.getContent().contains("transient: false"));
        TextPage page2 = (TextPage)client.getPage(this.getPath("/display", cid));
        Assert.assertTrue((boolean)page2.getContent().contains("message: Hola!"));
        Assert.assertTrue((boolean)page2.getContent().contains("cid: [" + cid + "]"));
        Assert.assertTrue((boolean)page2.getContent().contains("transient: false"));
    }

    @Test
    @SpecAssertion(section="conversation_context", id="qa")
    public void testInvalidatingSessionDestroysConversation() throws Exception {
        WebClient client = new WebClient();
        TextPage initialPage = (TextPage)client.getPage(this.getPath("/begin", null));
        String content = initialPage.getContent();
        Assert.assertTrue((boolean)content.contains("message: Hello"));
        Assert.assertTrue((boolean)content.contains("transient: false"));
        String cid = this.getCid(content);
        client.getPage(this.getPath("/invalidateSession", cid));
        client.setThrowExceptionOnFailingStatusCode(false);
        Page page = client.getPage(this.getPath("/display", cid));
        Assert.assertEquals((int)page.getWebResponse().getStatusCode(), (int)500);
    }

    protected String getCid(String content) {
        return content.substring(content.indexOf("cid: [") + 6, content.indexOf("]"));
    }

    protected String getPath(String viewId, String cid) {
        StringBuilder builder = new StringBuilder(this.url.toString());
        builder.append("/servlet");
        builder.append(viewId);
        if (cid != null) {
            builder.append("?");
            builder.append("cid");
            builder.append("=");
            builder.append(cid);
        }
        return builder.toString();
    }

    protected <T extends HtmlElement> T getFirstMatchingElement(HtmlPage page, Class<T> elementClass, String id) {
        Set<T> inputs = this.getElements(page.getBody(), elementClass);
        for (HtmlElement input : inputs) {
            if (!input.getId().contains(id)) continue;
            return (T)input;
        }
        return null;
    }

    protected <T> Set<T> getElements(HtmlElement rootElement, Class<T> elementClass) {
        HashSet<T> result = new HashSet<T>();
        for (HtmlElement element : rootElement.getChildElements()) {
            result.addAll(this.getElements(element, elementClass));
        }
        if (elementClass.isInstance(rootElement)) {
            result.add(elementClass.cast(rootElement));
        }
        return result;
    }
}

