/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic.event.Info;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic.event.InfoObserver;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic.event.Nice;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.dynamic.event.Notifier;
import org.jboss.cdi.tck.util.Assert;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EventMetadataTest
extends AbstractTest {
    @Inject
    Notifier notifier;
    @Inject
    InfoObserver infoObserver;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EventMetadataTest.class)).build();
    }

    @Test
    @SpecAssertion(section="injection_point", id="aac")
    public void testInjectionPointGetBean() {
        Bean<?> lastBean = null;
        this.notifier.fireInfoEvent();
        lastBean = this.infoObserver.getLastBean();
        org.testng.Assert.assertNotNull(lastBean);
        org.testng.Assert.assertEquals((Object)lastBean.getBeanClass(), Notifier.class);
        this.notifier.fireInitializerInfoEvent();
        lastBean = this.infoObserver.getLastBean();
        org.testng.Assert.assertNotNull(lastBean);
        org.testng.Assert.assertEquals((Object)lastBean.getBeanClass(), Notifier.class);
        this.notifier.fireConstructorInfoEvent();
        lastBean = this.infoObserver.getLastBean();
        org.testng.Assert.assertNotNull(lastBean);
        org.testng.Assert.assertEquals((Object)lastBean.getBeanClass(), Notifier.class);
    }

    @Test
    @SpecAssertion(section="injection_point", id="dcc")
    public void testInjectionPointIsTransient() {
        this.notifier.fireInfoEvent();
        org.testng.Assert.assertFalse((boolean)this.infoObserver.isLastIsTransient());
        this.notifier.fireTransientInfoEvent();
        org.testng.Assert.assertTrue((boolean)this.infoObserver.isLastIsTransient());
    }

    @Test
    @SpecAssertion(section="injection_point", id="bab")
    public void testInjectionPointGetType() {
        Type lastType = null;
        this.notifier.fireInfoEvent();
        lastType = this.infoObserver.getLastType();
        org.testng.Assert.assertNotNull((Object)lastType);
        org.testng.Assert.assertEquals((Object)lastType, Info.class);
        this.notifier.fireInitializerInfoEvent();
        lastType = this.infoObserver.getLastType();
        org.testng.Assert.assertNotNull((Object)lastType);
        org.testng.Assert.assertEquals((Object)lastType, Info.class);
        this.notifier.fireConstructorInfoEvent();
        lastType = this.infoObserver.getLastType();
        org.testng.Assert.assertNotNull((Object)lastType);
        org.testng.Assert.assertEquals((Object)lastType, Info.class);
    }

    @Test
    @SpecAssertion(section="injection_point", id="bcb")
    public void testInjectionPointGetQualifiers() {
        Set<Annotation> lastQualifiers = null;
        this.notifier.fireInfoEvent();
        lastQualifiers = this.infoObserver.getLastQualifiers();
        org.testng.Assert.assertNotNull(lastQualifiers);
        Assert.assertAnnotationSetMatches(lastQualifiers, Default.class);
        this.notifier.fireConstructorInfoEvent();
        lastQualifiers = this.infoObserver.getLastQualifiers();
        org.testng.Assert.assertNotNull(lastQualifiers);
        Assert.assertAnnotationSetMatches(lastQualifiers, Nice.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_point", id="cab"), @SpecAssertion(section="injection_point", id="cbb")})
    public void testInjectionPointGetMember() {
        Member lastMember = null;
        this.notifier.fireInfoEvent();
        lastMember = this.infoObserver.getLastMember();
        org.testng.Assert.assertNotNull((Object)lastMember);
        org.testng.Assert.assertTrue((boolean)(lastMember instanceof Field));
        Field field = (Field)lastMember;
        org.testng.Assert.assertEquals((String)field.getName(), (String)"infoEvent");
        org.testng.Assert.assertEquals(field.getType(), Event.class);
        org.testng.Assert.assertEquals(field.getDeclaringClass(), Notifier.class);
        this.notifier.fireInitializerInfoEvent();
        lastMember = this.infoObserver.getLastMember();
        org.testng.Assert.assertNotNull((Object)lastMember);
        org.testng.Assert.assertTrue((boolean)(lastMember instanceof Method));
        Method method = (Method)lastMember;
        org.testng.Assert.assertEquals((String)method.getName(), (String)"setInitializerInjectionInfoEvent");
        org.testng.Assert.assertEquals((int)method.getParameterTypes().length, (int)1);
        org.testng.Assert.assertEquals(method.getDeclaringClass(), Notifier.class);
    }

    @Test
    @SpecAssertion(section="injection_point", id="dac")
    public void testInjectionPointGetAnnotatedType() {
        Annotated lastAnnotated = null;
        this.notifier.fireInfoEvent();
        lastAnnotated = this.infoObserver.getLastAnnotated();
        org.testng.Assert.assertTrue((boolean)(lastAnnotated instanceof AnnotatedField));
        org.testng.Assert.assertEquals((String)((AnnotatedField)lastAnnotated).getJavaMember().getName(), (String)"infoEvent");
        org.testng.Assert.assertTrue((boolean)lastAnnotated.isAnnotationPresent(Inject.class));
        this.notifier.fireConstructorInfoEvent();
        lastAnnotated = this.infoObserver.getLastAnnotated();
        org.testng.Assert.assertTrue((boolean)(lastAnnotated instanceof AnnotatedParameter));
        org.testng.Assert.assertEquals((int)((AnnotatedParameter)lastAnnotated).getPosition(), (int)0);
        org.testng.Assert.assertTrue((boolean)lastAnnotated.isAnnotationPresent(Nice.class));
    }
}

