/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.passivating.dependency.builtin;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.passivating.dependency.builtin.Boss;
import org.jboss.cdi.tck.tests.context.passivating.dependency.builtin.Hammer;
import org.jboss.cdi.tck.tests.context.passivating.dependency.builtin.Worker;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class BuiltinBeanPassivationDependencyTest
extends AbstractTest {
    @Inject
    Worker worker;
    @Inject
    Boss boss;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinBeanPassivationDependencyTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable_dependency", id="ea")})
    public void testInstance() throws IOException, ClassNotFoundException {
        Assert.assertNotNull((Object)this.worker);
        Assert.assertNotNull(this.worker.getInstance());
        Hammer hammer = (Hammer)this.worker.getInstance().get();
        Assert.assertNotNull((Object)hammer);
        String workerId = this.worker.getId();
        String hammerId = hammer.getId();
        byte[] serializedWorker = this.passivate(this.worker);
        Worker workerCopy = (Worker)this.activate(serializedWorker);
        Assert.assertNotNull((Object)workerCopy);
        Assert.assertNotNull(workerCopy.getInstance());
        Assert.assertEquals((String)workerCopy.getId(), (String)workerId);
        Assert.assertEquals((String)((Hammer)workerCopy.getInstance().get()).getId(), (String)hammerId);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable_dependency", id="ed")})
    public void testBeanManager() throws IOException, ClassNotFoundException {
        Assert.assertNotNull((Object)this.boss);
        Assert.assertNotNull((Object)this.boss.getBeanManager());
        String bossId = this.boss.getId();
        byte[] serializedBoss = this.passivate(this.boss);
        Boss bossCopy = (Boss)this.activate(serializedBoss);
        Assert.assertNotNull((Object)bossCopy);
        Assert.assertNotNull((Object)bossCopy.getBeanManager());
        Assert.assertEquals((String)bossCopy.getId(), (String)bossId);
        Assert.assertEquals((int)bossCopy.getBeanManager().getBeans(Boss.class, new Annotation[0]).size(), (int)1);
    }
}

