/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session.async;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class SessionContextAsyncListenerTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionContextAsyncListenerTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="session_context", id="ad")})
    public void testSessionContextActiveOnComplete() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page01 = (TextPage)webClient.getPage(this.getPath("complete"));
        Assert.assertTrue((boolean)page01.getContent().contains("onTimeout: null"));
        Assert.assertTrue((boolean)page01.getContent().contains("onError: null"));
        Assert.assertFalse((boolean)page01.getContent().contains("onComplete: null"));
        String id = this.extractSimpleSessionBeanId(page01.getContent());
        Assert.assertNotNull((Object)id);
        Assert.assertFalse((boolean)id.isEmpty());
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="session_context", id="ad")})
    public void testSessionContextActiveOnTimeout() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page = (TextPage)webClient.getPage(this.getPath("timeout"));
        Assert.assertFalse((boolean)page.getContent().contains("onTimeout: null"));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="session_context", id="ad")})
    public void testSessionContextActiveOnError() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(false);
        TextPage page = (TextPage)webClient.getPage(this.getPath("error"));
        Assert.assertFalse((boolean)page.getContent().contains("onError: null"));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="session_context", id="ad")})
    public void testSessionContextActiveOnStartAsync() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page = (TextPage)webClient.getPage(this.getPath("loop"));
        Assert.assertFalse((boolean)page.getContent().contains("onStartAsync: null"));
        Assert.assertFalse((boolean)page.getContent().contains("onComplete: null"));
    }

    private String getPath(String test) {
        return this.contextPath + "AsyncServlet?test=" + test;
    }

    private String extractSimpleSessionBeanId(String content) {
        Matcher matcher = Pattern.compile("^(.+)(simpleSessionBeanId: )(.+)$").matcher(content);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        return null;
    }
}

