/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.conversation.AbstractConversationTest;
import org.jboss.cdi.tck.tests.context.conversation.Cloud;
import org.jboss.cdi.tck.tests.context.conversation.ConversationStatusServlet;
import org.jboss.cdi.tck.tests.context.conversation.ConversationTestPhaseListener;
import org.jboss.cdi.tck.tests.context.conversation.OutermostFilter;
import org.jboss.cdi.tck.tests.context.conversation.Storm;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class LongRunningConversationPropagatedByFacesContextTest
extends AbstractConversationTest {
    private static final String STORM_STRENGTH = "12";
    private static final String REDIRECT_STORM_STRENGTH = "15";
    private static final String AJAX_STORM_STRENGTH = "20";

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassDefinition(LongRunningConversationPropagatedByFacesContextTest.class)).withClasses(Storm.class, ConversationTestPhaseListener.class, ConversationStatusServlet.class, Cloud.class, OutermostFilter.class)).withWebResource("storm.xhtml")).withWebResource("storm-ajax.xhtml")).withWebResource("thunder.xhtml")).withWebResource("lightening.xhtml")).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withWebXml("web.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="conversation_context", id="l"), @SpecAssertion(section="builtin_scopes", id="ba")})
    public void testConversationPropagated() throws Exception {
        WebClient webClient = new WebClient();
        HtmlPage storm = (HtmlPage)webClient.getPage(this.getPath("storm.jsf"));
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "beginConversationButton");
        storm = (HtmlPage)beginConversationButton.click();
        HtmlTextInput stormStrength = this.getFirstMatchingElement(storm, HtmlTextInput.class, "stormStrength");
        stormStrength.setValueAttribute(STORM_STRENGTH);
        String stormCid = this.getCid((Page)storm);
        HtmlSubmitInput thunderButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "thunderButton");
        HtmlPage thunder = (HtmlPage)thunderButton.click();
        Assert.assertEquals((String)stormCid, (String)this.getCid((Page)thunder));
        stormStrength = this.getFirstMatchingElement(thunder, HtmlTextInput.class, "stormStrength");
        Assert.assertEquals((String)stormStrength.getValueAttribute(), (String)STORM_STRENGTH);
    }

    @Test
    @SpecAssertion(section="conversation_context", id="m")
    public void testConversationPropagatedOverRedirect() throws Exception {
        WebClient webClient = new WebClient();
        HtmlPage storm = (HtmlPage)webClient.getPage(this.getPath("storm.jsf"));
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "beginConversationButton");
        storm = (HtmlPage)beginConversationButton.click();
        HtmlTextInput stormStrength = this.getFirstMatchingElement(storm, HtmlTextInput.class, "stormStrength");
        stormStrength.setValueAttribute(REDIRECT_STORM_STRENGTH);
        String stormCid = this.getCid((Page)storm);
        HtmlSubmitInput lighteningButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "lighteningButton");
        HtmlPage lightening = (HtmlPage)lighteningButton.click();
        Assert.assertTrue((boolean)lightening.getWebResponse().getWebRequest().getUrl().toString().contains("lightening.jsf"));
        Assert.assertEquals((String)stormCid, (String)this.getCid((Page)lightening));
        stormStrength = this.getFirstMatchingElement(lightening, HtmlTextInput.class, "stormStrength");
        Assert.assertEquals((String)stormStrength.getValueAttribute(), (String)REDIRECT_STORM_STRENGTH);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="conversation_context", id="l")})
    public void testConversationPropagatedAjax() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
        HtmlPage storm = (HtmlPage)webClient.getPage(this.getPath("storm-ajax.jsf"));
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "beginConversationButton");
        storm = (HtmlPage)beginConversationButton.click();
        String cid = this.getFirstMatchingElement(storm, HtmlInput.class, "conversationId").getValueAttribute();
        Assert.assertFalse((boolean)cid.isEmpty());
        HtmlTextInput stormStrength = this.getFirstMatchingElement(storm, HtmlTextInput.class, "stormStrength");
        stormStrength.setValueAttribute(AJAX_STORM_STRENGTH);
        HtmlSubmitInput thunderButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "thunderButton");
        thunderButton.click();
        HtmlPage thunder = (HtmlPage)webClient.getPage(this.getPath("thunder.jsf", cid));
        stormStrength = this.getFirstMatchingElement(thunder, HtmlTextInput.class, "stormStrength");
        Assert.assertEquals((String)stormStrength.getValueAttribute(), (String)AJAX_STORM_STRENGTH);
    }
}

