/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.event.jms;

import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.jboss.cdi.tck.tests.context.request.event.jms.RequestScopedObserver;

public class AbstractMessageListener
implements MessageListener {
    private static AtomicInteger processedMessages = new AtomicInteger(0);
    private static boolean initializedEventObserver;
    @Inject
    private RequestScopedObserver observer;

    public void onMessage(Message message) {
        if (!(message instanceof TextMessage)) {
            throw new IllegalArgumentException("Unsupported message type");
        }
        processedMessages.incrementAndGet();
        initializedEventObserver = this.observer.isInitializedObserved();
    }

    public static void reset() {
        processedMessages.set(0);
        initializedEventObserver = false;
    }

    public static int getProcessedMessages() {
        return processedMessages.get();
    }

    public static boolean isInitializedEventObserver() {
        return initializedEventObserver;
    }
}

