/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.qualifier.enterprise;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.qualifier.enterprise.BorderCollieLocal;
import org.jboss.cdi.tck.tests.definition.qualifier.enterprise.EnglishBorderCollieLocal;
import org.jboss.cdi.tck.tests.definition.qualifier.enterprise.FamousCatLocal;
import org.jboss.cdi.tck.tests.definition.qualifier.enterprise.Hairy;
import org.jboss.cdi.tck.tests.definition.qualifier.enterprise.HairyQualifier;
import org.jboss.cdi.tck.tests.definition.qualifier.enterprise.SkinnyQualifier;
import org.jboss.cdi.tck.tests.definition.qualifier.enterprise.TameSkinnyHairlessCatLocal;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EnterpriseQualifierDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseQualifierDefinitionTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_level_inheritance", id="al")
    public void testQualifierDeclaredInheritedIsInherited() throws Exception {
        Set qualifiers = this.getBeans(BorderCollieLocal.class, new HairyQualifier(false)).iterator().next().getQualifiers();
        assert (this.annotationSetMatches((Set<? extends Annotation>)qualifiers, Any.class, Hairy.class));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_level_inheritance", id="ala")
    public void testQualifierNotDeclaredInheritedIsNotInherited() throws Exception {
        assert (this.getBeans(TameSkinnyHairlessCatLocal.class, new SkinnyQualifier()).size() == 0);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_level_inheritance", id="ap")
    public void testQualifierDeclaredInheritedIsIndirectlyInherited() {
        Set qualifiers = this.getBeans(EnglishBorderCollieLocal.class, new HairyQualifier(false)).iterator().next().getQualifiers();
        assert (this.annotationSetMatches((Set<? extends Annotation>)qualifiers, Any.class, Hairy.class));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="type_level_inheritance", id="apa")
    public void testQualifierNotDeclaredInheritedIsNotIndirectlyInherited() {
        Set<Bean<FamousCatLocal>> beans = this.getBeans(FamousCatLocal.class, new SkinnyQualifier());
        assert (beans.size() == 0);
    }
}

