/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.conditional;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Reception;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.conditional.ConditionalEvent;
import org.jboss.cdi.tck.tests.event.observer.conditional.RecluseSpider;
import org.jboss.cdi.tck.tests.event.observer.conditional.Tarantula;
import org.jboss.cdi.tck.tests.event.observer.conditional.TarantulaEvent;
import org.jboss.cdi.tck.tests.event.observer.conditional.Web;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ConditionalObserverTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConditionalObserverTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observers_method_invocation", id="baa"), @SpecAssertion(section="conditional_observer_methods", id="a")})
    public void testConditionalObserver() {
        RecluseSpider.reset();
        this.getCurrentManager().fireEvent((Object)new ConditionalEvent(), new Annotation[0]);
        assert (!RecluseSpider.isNotified());
        RecluseSpider bean = this.getContextualReference(RecluseSpider.class, new Annotation[0]);
        assert (bean != null);
        assert (!bean.isInstanceNotified());
        this.getCurrentManager().fireEvent((Object)new ConditionalEvent(), new Annotation[0]);
        assert (RecluseSpider.isNotified() && bean.isInstanceNotified());
        RecluseSpider.reset();
    }

    @Test
    @SpecAssertion(section="observers_method_invocation", id="baa")
    public void testObserverMethodInvokedOnReturnedInstanceFromContext() {
        RecluseSpider spider = this.getContextualReference(RecluseSpider.class, new Annotation[0]);
        spider.setWeb(new Web());
        this.getCurrentManager().fireEvent((Object)new ConditionalEvent(), new Annotation[0]);
        assert (spider.isInstanceNotified());
        assert (spider.getWeb().getRings() == 1);
    }

    @Test
    @SpecAssertion(section="conditional_observer_methods", id="c")
    public void testNotifyEnumerationContainsNotifyValues() {
        assert (Reception.values().length == 2);
        ArrayList<String> notifyValueNames = new ArrayList<String>();
        for (Reception value : Reception.values()) {
            notifyValueNames.add(value.name());
        }
        assert (notifyValueNames.contains("IF_EXISTS"));
        assert (notifyValueNames.contains("ALWAYS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration"})
    @SpecAssertion(section="observer_notification", id="bca")
    public void testConditionalObserverMethodNotInvokedIfNoActiveContext() {
        Tarantula.reset();
        Context requestContext = this.getCurrentConfiguration().getContexts().getRequestContext();
        Tarantula tarantula = this.getContextualReference(Tarantula.class, new Annotation[0]);
        tarantula.ping();
        try {
            this.setContextInactive(requestContext);
            this.getCurrentManager().fireEvent((Object)new TarantulaEvent(), new Annotation[0]);
            Assert.assertFalse((boolean)Tarantula.isNotified());
        }
        finally {
            this.setContextActive(requestContext);
        }
        this.getCurrentManager().fireEvent((Object)new TarantulaEvent(), new Annotation[0]);
        Assert.assertTrue((boolean)Tarantula.isNotified());
    }
}

