/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.clientProxy;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.clientProxy.Tuna;
import org.jboss.cdi.tck.tests.lookup.clientProxy.TunedTuna;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ClientProxyTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ClientProxyTest.class)).build();
    }

    @Test
    @SpecAssertion(section="client_proxies", id="b")
    public void testClientProxyUsedForNormalScope() {
        Tuna tuna = this.getContextualReference(Tuna.class, new Annotation[0]);
        assert (this.getCurrentConfiguration().getBeans().isProxy((Object)tuna));
    }

    @Test
    @SpecAssertion(section="client_proxies", id="c")
    public void testSimpleBeanClientProxyIsSerializable() throws IOException, ClassNotFoundException {
        TunedTuna tuna = this.getContextualReference(TunedTuna.class, new Annotation[0]);
        assert (this.getCurrentConfiguration().getBeans().isProxy((Object)tuna));
        byte[] bytes = this.passivate(tuna);
        tuna = (TunedTuna)this.activate(bytes);
        assert (this.getCurrentConfiguration().getBeans().isProxy((Object)tuna));
        assert (tuna.getState().equals("tuned"));
    }

    @Test
    @SpecAssertion(section="client_proxy_invocation", id="aa")
    public void testClientProxyInvocation() {
        TunedTuna tuna = this.getContextualReference(TunedTuna.class, new Annotation[0]);
        assert (this.getCurrentConfiguration().getBeans().isProxy((Object)tuna));
        assert (tuna.getState().equals("tuned"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration"}, expectedExceptions={ContextNotActiveException.class, IllegalStateException.class})
    @SpecAssertions(value={@SpecAssertion(section="client_proxy_invocation", id="ab"), @SpecAssertion(section="contextual_reference_validity", id="a")})
    public void testInactiveScope() throws Exception {
        assert (this.getCurrentConfiguration().getContexts().getRequestContext().isActive());
        Context ctx = this.getCurrentConfiguration().getContexts().getRequestContext();
        this.setContextInactive(ctx);
        assert (!this.getCurrentConfiguration().getContexts().getRequestContext().isActive());
        try {
            this.getContextualReference(TunedTuna.class, new Annotation[0]).getState();
        }
        finally {
            this.setContextActive(ctx);
        }
    }
}

