/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.discovery;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.descriptors.Beans11DescriptorImpl;
import org.jboss.cdi.tck.tests.deployment.discovery.Alpha;
import org.jboss.cdi.tck.tests.deployment.discovery.Bravo;
import org.jboss.cdi.tck.tests.deployment.discovery.Charlie;
import org.jboss.cdi.tck.tests.deployment.discovery.Delta;
import org.jboss.cdi.tck.tests.deployment.discovery.Echo;
import org.jboss.cdi.tck.tests.deployment.discovery.EchoNotABean;
import org.jboss.cdi.tck.tests.deployment.discovery.Foxtrot;
import org.jboss.cdi.tck.tests.deployment.discovery.LegacyAlpha;
import org.jboss.cdi.tck.tests.deployment.discovery.LegacyBravo;
import org.jboss.cdi.tck.tests.deployment.discovery.LegacyExtension;
import org.jboss.cdi.tck.tests.deployment.discovery.Ping;
import org.jboss.cdi.tck.tests.deployment.discovery.VerifyingExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class BeanDiscoveryTest
extends AbstractTest {
    @Inject
    VerifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        JavaArchive alpha = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Alpha.class)).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.ALL).exportAsString()), "beans.xml");
        JavaArchive bravo = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Bravo.class)).addAsManifestResource((Asset)new StringAsset(""), "beans.xml");
        JavaArchive charlie = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Charlie.class)).addAsManifestResource((Asset)new StringAsset(((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString()), "beans.xml");
        JavaArchive delta = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Delta.class);
        JavaArchive echo = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Echo.class, EchoNotABean.class})).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.ANNOTATED).exportAsString()), "beans.xml");
        JavaArchive foxtrot = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Foxtrot.class)).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.NONE).exportAsString()), "beans.xml");
        JavaArchive legacy = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{LegacyExtension.class, LegacyAlpha.class, LegacyBravo.class})).addAsServiceProvider(Extension.class, new Class[]{LegacyExtension.class});
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(BeanDiscoveryTest.class)).withClasses(VerifyingExtension.class)).withExtension(VerifyingExtension.class)).withLibrary(Ping.class)).withLibraries(alpha, bravo, charlie, delta, echo, foxtrot, legacy)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ba"), @SpecAssertion(section="bean_discovery", id="ta")})
    public void testExplicitBeanArchiveModeAll(Alpha alpha) {
        this.assertDiscoveredAndAvailable(alpha, Alpha.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="bb"), @SpecAssertion(section="bean_archive", id="bc"), @SpecAssertion(section="bean_discovery", id="ta")})
    public void testExplicitBeanArchiveEmptyDescriptor(Bravo bravo) {
        this.assertDiscoveredAndAvailable(bravo, Bravo.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="bc"), @SpecAssertion(section="bean_archive", id="bc"), @SpecAssertion(section="bean_discovery", id="ta")})
    public void testExplicitBeanArchiveLegacyDescriptor(Charlie charlie) {
        this.assertDiscoveredAndAvailable(charlie, Charlie.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ca"), @SpecAssertion(section="bean_discovery", id="tb"), @SpecAssertion(section="bean_defining_annotations", id="b")})
    public void testImplicitBeanArchiveNoDescriptor(Delta delta) {
        this.assertDiscoveredAndAvailable(delta, Delta.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ca"), @SpecAssertion(section="bean_discovery", id="tb"), @SpecAssertion(section="bean_defining_annotations", id="b")})
    public void testImplicitBeanArchiveModeAnnotated(Echo echo) {
        this.assertDiscoveredAndAvailable(echo, Echo.class);
        this.assertNotDiscoveredAndNotAvailable(EchoNotABean.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="oa")})
    public void testNoBeanArchiveModeNone() {
        this.assertNotDiscoveredAndNotAvailable(Foxtrot.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ob")})
    public void testNotBeanArchiveExtension(LegacyAlpha legacyAlpha) {
        this.assertDiscoveredAndAvailable(legacyAlpha, LegacyAlpha.class);
        this.assertNotDiscoveredAndNotAvailable(LegacyBravo.class);
    }

    private <T extends Ping> void assertDiscoveredAndAvailable(T reference, Class<T> clazz) {
        Assert.assertTrue((boolean)this.extension.getObservedAnnotatedTypes().contains(clazz));
        Assert.assertNotNull(reference);
        reference.pong();
        this.getUniqueBean(clazz, new Annotation[0]);
    }

    private <T> void assertNotDiscoveredAndNotAvailable(Class<T> clazz) {
        Assert.assertFalse((boolean)this.extension.getObservedAnnotatedTypes().contains(clazz));
        Assert.assertTrue((boolean)this.getBeans(clazz, new Annotation[0]).isEmpty());
    }
}

