/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.discovery.enterprise;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.descriptors.Beans11DescriptorImpl;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Alpha;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.AlphaLocal;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Bravo;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.BravoLocal;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Charlie;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.CharlieLocal;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Delta;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.DeltaLocal;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Echo;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.EchoLocal;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Foxtrot;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.FoxtrotLocal;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.LegacyBean;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.LegacyExtension;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.Ping;
import org.jboss.cdi.tck.tests.deployment.discovery.enterprise.VerifyingExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EnterpriseBeanDiscoveryTest
extends AbstractTest {
    private static final String ALPHA_JAR = "alpha.jar";
    private static final String BRAVO_JAR = "bravo.jar";
    private static final String CHARLIE_JAR = "charlie.jar";
    private static final String DELTA_JAR = "delta.jar";
    private static final String ECHO_JAR = "echo.jar";
    private static final String FOXTROT_JAR = "foxtrot.jar";
    private static final String LEGACY_JAR = "legacy.jar";
    @Inject
    VerifyingExtension extension;

    @Deployment
    public static EnterpriseArchive createTestArchive() {
        JavaArchive alpha = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)ALPHA_JAR)).addClasses(new Class[]{Alpha.class, AlphaLocal.class})).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.ALL).exportAsString()), "beans.xml");
        JavaArchive bravo = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)BRAVO_JAR)).addClasses(new Class[]{Bravo.class, BravoLocal.class})).addAsManifestResource((Asset)new StringAsset(""), "beans.xml");
        JavaArchive charlie = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)CHARLIE_JAR)).addClasses(new Class[]{Charlie.class, CharlieLocal.class})).addAsManifestResource((Asset)new StringAsset(((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString()), "beans.xml");
        JavaArchive delta = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)DELTA_JAR)).addClasses(new Class[]{Delta.class, DeltaLocal.class});
        JavaArchive echo = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)ECHO_JAR)).addClasses(new Class[]{Echo.class, EchoLocal.class})).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.ANNOTATED).exportAsString()), "beans.xml");
        JavaArchive foxtrot = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)FOXTROT_JAR)).addClasses(new Class[]{Foxtrot.class, FoxtrotLocal.class})).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.NONE).exportAsString()), "beans.xml");
        JavaArchive legacy = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)LEGACY_JAR)).addClasses(new Class[]{LegacyExtension.class, LegacyBean.class})).addAsServiceProvider(Extension.class, new Class[]{LegacyExtension.class});
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withClasses(EnterpriseBeanDiscoveryTest.class)).notTestArchive()).build()).setManifest((Asset)new StringAsset(((ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).addToClassPath("test-ejb.jar")).addToClassPath(ALPHA_JAR)).addToClassPath(BRAVO_JAR)).addToClassPath(CHARLIE_JAR)).addToClassPath(DELTA_JAR)).addToClassPath(ECHO_JAR)).addToClassPath(FOXTROT_JAR)).addToClassPath(LEGACY_JAR)).exportAsString()));
        return (EnterpriseArchive)((EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().noDefaultWebModule().withTestClassDefinition(EnterpriseBeanDiscoveryTest.class)).withClasses(VerifyingExtension.class)).withExtension(VerifyingExtension.class)).withLibrary(Ping.class)).build()).addAsModules(new Archive[]{webArchive, alpha, bravo, charlie, delta, echo, foxtrot, legacy});
    }

    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ba"), @SpecAssertion(section="bean_discovery", id="tc")})
    public void testExplicitBeanArchiveModeAll() {
        this.assertDiscoveredAndAvailable(AlphaLocal.class, Alpha.class);
    }

    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="bb"), @SpecAssertion(section="bean_archive", id="bc"), @SpecAssertion(section="bean_discovery", id="tc")})
    public void testExplicitBeanArchiveEmptyDescriptor() {
        this.assertDiscoveredAndAvailable(BravoLocal.class, Bravo.class);
    }

    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="bc"), @SpecAssertion(section="bean_discovery", id="tc"), @SpecAssertion(section="bean_discovery", id="ta")})
    public void testExplicitBeanArchiveLegacyDescriptor() {
        this.assertDiscoveredAndAvailable(CharlieLocal.class, Charlie.class);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ca"), @SpecAssertion(section="bean_discovery", id="tc"), @SpecAssertion(section="bean_defining_annotations", id="b")})
    public void testImplicitBeanArchiveNoDescriptor() {
        this.assertDiscoveredAndAvailable(DeltaLocal.class, Delta.class);
    }

    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ca"), @SpecAssertion(section="bean_discovery", id="tc"), @SpecAssertion(section="bean_defining_annotations", id="b")})
    public void testImplicitBeanArchiveModeAnnotated() {
        this.assertDiscoveredAndAvailable(EchoLocal.class, Echo.class);
    }

    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="oa"), @SpecAssertion(section="bean_discovery", id="tc")})
    public void testNoBeanArchiveModeNone() {
        this.assertNotDiscoveredAndNotAvailable(FoxtrotLocal.class, Foxtrot.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ob")})
    public void testNotBeanArchiveExtension() {
        this.assertNotDiscoveredAndNotAvailable(LegacyBean.class, LegacyBean.class);
    }

    private <T extends Ping, B extends Ping> void assertDiscoveredAndAvailable(Class<T> beanType, Class<B> beanClazz) {
        Ping instance = (Ping)this.getContextualReference(beanType, new Annotation[0]);
        Assert.assertNotNull((Object)instance);
        Assert.assertTrue((boolean)this.extension.getObservedAnnotatedTypes().contains(beanClazz));
        instance.pong();
    }

    private <T extends Ping, B extends Ping> void assertNotDiscoveredAndNotAvailable(Class<T> beanType, Class<B> beanClazz) {
        Assert.assertFalse((boolean)this.extension.getObservedAnnotatedTypes().contains(beanClazz));
        Assert.assertTrue((boolean)this.getBeans(beanType, new Annotation[0]).isEmpty());
    }
}

