/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.metadata.Alpha;
import org.jboss.cdi.tck.tests.event.metadata.Bravo;
import org.jboss.cdi.tck.tests.event.metadata.Charlie;
import org.jboss.cdi.tck.tests.event.metadata.Duck;
import org.jboss.cdi.tck.tests.event.metadata.DuckNotifier;
import org.jboss.cdi.tck.tests.event.metadata.DuckObserver;
import org.jboss.cdi.tck.tests.event.metadata.SimpleEvent;
import org.jboss.cdi.tck.tests.event.metadata.SimpleEventNotifier;
import org.jboss.cdi.tck.tests.event.metadata.SimpleEventObserver;
import org.jboss.cdi.tck.util.Assert;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class EventMetadataTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EventMetadataTest.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="event_metadata", id="a"), @SpecAssertion(section="event_metadata", id="b"), @SpecAssertion(section="event_metadata", id="c"), @SpecAssertion(section="event_metadata", id="d")})
    public void testSimpleEvent(SimpleEventNotifier notifier, SimpleEventObserver observer) {
        org.testng.Assert.assertNotNull((Object)notifier);
        org.testng.Assert.assertNotNull((Object)observer);
        notifier.fireSimpleEvent();
        this.verifyMetadata(observer.getMetadata(), true, (Type)((Object)SimpleEvent.class), Any.class);
        notifier.fireSimpleEventBeanManager();
        this.verifyMetadata(observer.getMetadata(), false, (Type)((Object)SimpleEvent.class), Any.class);
        notifier.fireSimpleEventWithQualifiers();
        this.verifyMetadata(observer.getMetadata(), true, (Type)((Object)SimpleEvent.class), Alpha.class, Bravo.class, Any.class);
        notifier.fireSimpleEventBeanManagerWithQualifiers();
        this.verifyMetadata(observer.getMetadata(), false, (Type)((Object)SimpleEvent.class), Charlie.class, Any.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={})
    public void testParameterizedResolvedType(DuckNotifier notifier, DuckObserver observer) {
        org.testng.Assert.assertNotNull((Object)notifier);
        org.testng.Assert.assertNotNull((Object)observer);
        notifier.fireStringDuck();
        this.verifyMetadata(observer.getMetadata(), true, new TypeLiteral<Duck<String>>(){}.getType(), Any.class);
        notifier.fireMapDuck();
        this.verifyMetadata(observer.getMetadata(), true, new TypeLiteral<Duck<Map<String, Integer>>>(){}.getType(), Any.class, Bravo.class);
        notifier.fireListDuck();
        this.verifyMetadata(observer.getMetadata(), true, new TypeLiteral<ArrayList<Duck<Number>>>(){}.getType(), Any.class);
    }

    private void verifyMetadata(EventMetadata metadata, boolean isInjectionPointAvailable, Type resolvedType, Class<? extends Annotation> ... qualifiers) {
        org.testng.Assert.assertNotNull((Object)metadata);
        if (isInjectionPointAvailable) {
            org.testng.Assert.assertNotNull((Object)metadata.getInjectionPoint());
        } else {
            org.testng.Assert.assertNull((Object)metadata.getInjectionPoint());
        }
        org.testng.Assert.assertEquals((Object)metadata.getType(), (Object)resolvedType);
        Assert.assertAnnotationSetMatches(metadata.getQualifiers(), qualifiers);
    }
}

