/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.Android;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.Fate;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.Human;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.InheritedQualifier;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.Kryten;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.Mortal;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.ObservingExtension;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.annotated.Rimmer;
import org.jboss.cdi.tck.util.Assert;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class AnnotatedTypeAnnotationsTest
extends AbstractTest {
    @Inject
    ObservingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AnnotatedTypeAnnotationsTest.class)).withExtension(ObservingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="alternative_metadata_sources", id="b")})
    public void testCreateAnnotatedType() {
        Assert.assertAnnotationSetMatches(this.getCurrentManager().createAnnotatedType(Android.class).getAnnotations(), RequestScoped.class, InheritedQualifier.class, Fate.class);
        Assert.assertAnnotationSetMatches(this.getCurrentManager().createAnnotatedType(Rimmer.class).getAnnotations(), Mortal.class, Dependent.class, InheritedQualifier.class, Fate.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="alternative_metadata_sources", id="b")})
    public void testProcessAnnotatedType() {
        AnnotatedType<Kryten> kryten = this.extension.getKryten();
        org.testng.Assert.assertNotNull(kryten);
        Assert.assertAnnotationSetMatches(kryten.getAnnotations(), RequestScoped.class, InheritedQualifier.class, Fate.class);
        AnnotatedType<Rimmer> rimmer = this.extension.getRimmer();
        org.testng.Assert.assertNotNull(rimmer);
        Assert.assertAnnotationSetMatches(rimmer.getAnnotations(), Mortal.class, Dependent.class, InheritedQualifier.class, Fate.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="alternative_metadata_sources", id="b")})
    public void testGetAnnotatedType() {
        AnnotatedType<Android> android = this.extension.getAndroid();
        org.testng.Assert.assertNotNull(android);
        Assert.assertAnnotationSetMatches(android.getAnnotations(), RequestScoped.class, InheritedQualifier.class, Fate.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="alternative_metadata_sources", id="b")})
    public void testGetAnnotatedTypes() {
        List<AnnotatedType<Human>> humans = this.extension.getAllHumans();
        org.testng.Assert.assertNotNull(humans);
        org.testng.Assert.assertEquals((int)humans.size(), (int)1);
        Assert.assertAnnotationSetMatches(humans.iterator().next().getAnnotations(), Mortal.class, Dependent.class, InheritedQualifier.class, Fate.class);
        List<AnnotatedType<Android>> androids = this.extension.getAllAndroids();
        org.testng.Assert.assertNotNull(androids);
        org.testng.Assert.assertEquals((int)androids.size(), (int)1);
        Assert.assertAnnotationSetMatches(androids.iterator().next().getAnnotations(), RequestScoped.class, InheritedQualifier.class, Fate.class);
    }
}

