/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.container.event.jms;

import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.descriptors.ejb.EjbJarDescriptorBuilder;
import org.jboss.cdi.tck.tests.extensions.container.event.jms.ProcessInjectionTargetObserver;
import org.jboss.cdi.tck.tests.extensions.container.event.jms.QueueMessageDrivenBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.ejbjar31.EjbJarDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ContainerEventTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        EjbJarDescriptor ejbJarDescriptor = new EjbJarDescriptorBuilder().messageDrivenBeans(EjbJarDescriptorBuilder.MessageDriven.newMessageDriven("TestQueue", QueueMessageDrivenBean.class.getName()).addActivationConfigProperty("acknowledgeMode", "Auto-acknowledge").addActivationConfigProperty("destinationType", "javax.jms.Queue").addActivationConfigProperty("destinationLookup", ConfigurationFactory.get().getTestJmsQueue())).build();
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ContainerEventTest.class)).withEjbJarXml(ejbJarDescriptor)).withExtension(ProcessInjectionTargetObserver.class)).build();
    }

    @Test(groups={"javaee-full", "jms"})
    @SpecAssertions(value={@SpecAssertion(section="pit", id="aaba"), @SpecAssertion(section="pit", id="abba")})
    public void testProcessInjectionTargetEventFiredForMessageDrivenBean() {
        ProcessInjectionTarget<QueueMessageDrivenBean> event = ProcessInjectionTargetObserver.getMdbEvent();
        Assert.assertNotNull(event);
        AnnotatedType annotatedType = event.getAnnotatedType();
        Assert.assertEquals((Object)annotatedType.getBaseType(), QueueMessageDrivenBean.class);
        Assert.assertEquals((int)annotatedType.getMethods().size(), (int)2);
        for (AnnotatedMethod method : annotatedType.getMethods()) {
            if ("initialize".equals(method.getJavaMember().getName())) {
                Assert.assertTrue((boolean)method.isAnnotationPresent(Inject.class));
                Assert.assertEquals((int)method.getParameters().size(), (int)1);
                Assert.assertEquals((Object)method.getDeclaringType().getJavaClass(), QueueMessageDrivenBean.class);
                continue;
            }
            if ("onMessage".equals(method.getJavaMember().getName())) {
                Assert.assertEquals((int)method.getParameters().size(), (int)1);
                Assert.assertEquals((Object)method.getDeclaringType().getJavaClass(), QueueMessageDrivenBean.class);
                continue;
            }
            Assert.fail();
        }
        Assert.assertEquals((int)annotatedType.getFields().size(), (int)2);
        for (AnnotatedField field : annotatedType.getFields()) {
            if ("sheep".equals(field.getJavaMember().getName())) {
                Assert.assertTrue((boolean)field.isAnnotationPresent(Inject.class));
                Assert.assertEquals((Object)field.getDeclaringType().getJavaClass(), QueueMessageDrivenBean.class);
                continue;
            }
            if ("initializerCalled".equals(field.getJavaMember().getName())) {
                Assert.assertEquals((Object)field.getDeclaringType().getJavaClass(), QueueMessageDrivenBean.class);
                continue;
            }
            Assert.fail();
        }
    }
}

