/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.producer;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.producer.Bird;
import org.jboss.cdi.tck.tests.extensions.producer.BirdCage;
import org.jboss.cdi.tck.tests.extensions.producer.Cat;
import org.jboss.cdi.tck.tests.extensions.producer.CatFoodDish;
import org.jboss.cdi.tck.tests.extensions.producer.CheckableInjectionTarget;
import org.jboss.cdi.tck.tests.extensions.producer.Cow;
import org.jboss.cdi.tck.tests.extensions.producer.Dog;
import org.jboss.cdi.tck.tests.extensions.producer.DogBed;
import org.jboss.cdi.tck.tests.extensions.producer.DogProducer;
import org.jboss.cdi.tck.tests.extensions.producer.LitterBox;
import org.jboss.cdi.tck.tests.extensions.producer.Noisy;
import org.jboss.cdi.tck.tests.extensions.producer.ProducerProcessor;
import org.jboss.cdi.tck.tests.extensions.producer.Quiet;
import org.jboss.cdi.tck.tests.extensions.producer.ServiceRemote;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="20091101")
public class ProducerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerTest.class)).withExtension(ProducerProcessor.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="ba"), @SpecAssertion(section="injectiontarget", id="bb"), @SpecAssertion(section="injectiontarget", id="bc")})
    public void testProduceAndInjectCallsInitializerAndConstructor() {
        InjectionTarget<Cat> injectionTarget = ProducerProcessor.getCatInjectionTarget();
        Bean<Cat> catBean = this.getUniqueBean(Cat.class, new Annotation[0]);
        Cat.reset();
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(catBean);
        Cat instance = (Cat)injectionTarget.produce(ctx);
        assert (Cat.isConstructorCalled());
        injectionTarget.inject((Object)instance, ctx);
        assert (Cat.isInitializerCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="c")})
    public void testDisposeDoesNothing() {
        InjectionTarget<Cat> injectionTarget = ProducerProcessor.getCatInjectionTarget();
        Cat cat = this.getContextualReference(Cat.class, new Annotation[0]);
        injectionTarget.dispose((Object)cat);
        cat.ping();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="da")})
    public void testGetInjectionPointsForFields() {
        InjectionTarget<Cat> injectionTarget = ProducerProcessor.getCatInjectionTarget();
        assert (injectionTarget.getInjectionPoints().size() == 3);
        boolean injectionPointPresent = false;
        for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
            if (!injectionPoint.getType().equals(CatFoodDish.class)) continue;
            injectionPointPresent = true;
        }
        assert (injectionPointPresent);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="db"), @SpecAssertion(section="injectiontarget", id="dc")})
    public void testGetInjectionPointsForConstructorAndInitializer() {
        InjectionTarget<Cat> injectionTarget = ProducerProcessor.getCatInjectionTarget();
        assert (injectionTarget.getInjectionPoints().size() == 3);
        boolean constructorIPPresent = false;
        boolean initializerMethodIPPresent = false;
        for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
            if (injectionPoint.getType().equals(LitterBox.class)) {
                constructorIPPresent = true;
            }
            if (!injectionPoint.getType().equals(Bird.class)) continue;
            initializerMethodIPPresent = true;
        }
        assert (initializerMethodIPPresent);
        assert (constructorIPPresent);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="eaa"), @SpecAssertion(section="pp", id="aa"), @SpecAssertion(section="pp", id="ba"), @SpecAssertion(section="pp", id="ca"), @SpecAssertion(section="pp", id="da"), @SpecAssertion(section="bean_discovery", id="ha")})
    public void testProduceCallsProducerMethod() {
        Producer<Dog> producer = ProducerProcessor.getNoisyDogProducer();
        Bean<Dog> dogBean = this.getUniqueBean(Dog.class, new Annotation[]{new AnnotationLiteral<Noisy>(){}});
        DogProducer.reset();
        Dog dog = (Dog)producer.produce(this.getCurrentManager().createCreationalContext(dogBean));
        assert (DogProducer.isNoisyDogProducerCalled());
        assert (dog.getColor().equals("White"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pp", id="ac"), @SpecAssertion(section="pp", id="e"), @SpecAssertion(section="pp", id="gb")})
    public void testProduceCallsOverridenResourceProducerMethod() {
        Assert.assertEquals((String)this.getContextualReference(ServiceRemote.class, new Annotation[0]).ping(), (String)"pong");
        Assert.assertTrue((boolean)ProducerProcessor.isOverriddenServiceProducerCalled);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pp", id="e"), @SpecAssertion(section="pp", id="ga")})
    public void testSetProducerOverridesProducer() {
        ProducerProcessor.reset();
        assert (this.getContextualReference(Cow.class, new Annotation[]{new AnnotationLiteral<Noisy>(){}}) instanceof Cow);
        assert (ProducerProcessor.isOverriddenCowProducerCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="eba"), @SpecAssertion(section="pp", id="ab"), @SpecAssertion(section="pp", id="bb"), @SpecAssertion(section="pp", id="cb"), @SpecAssertion(section="pp", id="db"), @SpecAssertion(section="bean_discovery", id="hb")})
    public void testProduceAccessesProducerField() {
        Producer<Dog> producer = ProducerProcessor.getQuietDogProducer();
        Bean<Dog> dogBean = this.getUniqueBean(Dog.class, new Annotation[]{new AnnotationLiteral<Quiet>(){}});
        DogProducer.reset();
        Dog dog = (Dog)producer.produce(this.getCurrentManager().createCreationalContext(dogBean));
        assert (dog.getColor().equals("Black"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="faa")})
    public void testProducerForMethodDisposesProduct() {
        Bean<Dog> dogBean = this.getUniqueBean(Dog.class, new Annotation[]{new AnnotationLiteral<Noisy>(){}});
        Producer<Dog> producer = ProducerProcessor.getNoisyDogProducer();
        DogProducer.reset();
        Dog dog = (Dog)producer.produce(this.getCurrentManager().createCreationalContext(dogBean));
        assert (DogProducer.isNoisyDogProducerCalled());
        producer.dispose((Object)dog);
        assert (DogProducer.isNoisyDogDisposerCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="g")})
    public void testInjectionPointsForProducerMethod() {
        Producer<Dog> producer = ProducerProcessor.getNoisyDogProducer();
        DogProducer.reset();
        assert (producer.getInjectionPoints().size() == 1);
        assert (((InjectionPoint)producer.getInjectionPoints().iterator().next()).getType().equals(DogBed.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="i"), @SpecAssertion(section="bean_discovery", id="ba"), @SpecAssertion(section="pit", id="aaa")})
    public void testInjectionTargetInject() {
        InjectionTarget<Dog> injectionTarget = ProducerProcessor.getDogInjectionTarget();
        Bean dogBean = (Bean)this.getCurrentManager().getBeans(Dog.class, new Annotation[0]).iterator().next();
        CreationalContext dogCreationalContext = this.getCurrentManager().createCreationalContext((Contextual)dogBean);
        Dog dog = (Dog)dogBean.create(dogCreationalContext);
        dog.setDogBone(null);
        injectionTarget.inject((Object)dog, dogCreationalContext);
        assert (dog.getDogBone() != null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="j")})
    public void testInjectionTargetPostConstruct() {
        InjectionTarget<Dog> injectionTarget = ProducerProcessor.getDogInjectionTarget();
        Dog dog = this.getContextualReference(Dog.class, new Annotation[]{new AnnotationLiteral<Noisy>(){}});
        Dog.setPostConstructCalled(false);
        injectionTarget.postConstruct((Object)dog);
        assert (Dog.isPostConstructCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injectiontarget", id="k")})
    public void testInjectionTargetPreDestroy() {
        InjectionTarget<Dog> injectionTarget = ProducerProcessor.getDogInjectionTarget();
        Dog dog = this.getContextualReference(Dog.class, new Annotation[]{new AnnotationLiteral<Noisy>(){}});
        Dog.setPreDestroyCalled(false);
        injectionTarget.preDestroy((Object)dog);
        assert (Dog.isPreDestroyCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pit", id="bb"), @SpecAssertion(section="pit", id="ea")})
    public void testSettingInjectionTargetReplacesIt() {
        CheckableInjectionTarget.setInjectCalled(false);
        this.getContextualReference(BirdCage.class, new Annotation[0]);
        assert (CheckableInjectionTarget.isInjectCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pit", id="aba")})
    public void testGetAnnotatedTypeOnProcessInjectionTarget() {
        assert (ProducerProcessor.getDogAnnotatedType() != null);
        assert (ProducerProcessor.getDogAnnotatedType().getBaseType().equals(Dog.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pb", id="ec")})
    public void testResourceAreConsideredToBeProducerField() {
        Assert.assertTrue((boolean)ProducerProcessor.isServiceProducerFieldObserved);
    }
}

