/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.alterable;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.alterable.AbstractComponent;
import org.jboss.cdi.tck.tests.context.alterable.ApplicationScopedComponent;
import org.jboss.cdi.tck.tests.context.alterable.CustomScopeExtension;
import org.jboss.cdi.tck.tests.context.alterable.CustomScopedComponent;
import org.jboss.cdi.tck.tests.context.alterable.RequestScopedComponent;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class AlterableContextTest
extends AbstractTest {
    private static final String[] VALUES = new String[]{"foo", "bar", "baz"};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AlterableContextTest.class)).withExtension(CustomScopeExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="context", id="t")})
    public void testApplicationScopedComponent() {
        this.testComponent(ApplicationScopedComponent.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="context", id="t")})
    public void testRequestScopedComponent() {
        this.testComponent(RequestScopedComponent.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="context", id="t")})
    public void testCustomScopedComponent() {
        this.testComponent(CustomScopedComponent.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="context", id="t")})
    public void testNothingHappensIfNoInstanceToDestroy(ApplicationScopedComponent application) {
        Bean<ApplicationScopedComponent> bean = this.getUniqueBean(ApplicationScopedComponent.class, new Annotation[0]);
        AlterableContext context = (AlterableContext)this.getCurrentManager().getContext(bean.getScope());
        AbstractComponent.reset();
        application.setValue("value");
        context.destroy(bean);
        Assert.assertTrue((boolean)AbstractComponent.isDestroyed());
        context.destroy(bean);
        context.destroy(bean);
    }

    private <T extends AbstractComponent> void testComponent(Class<T> javaClass) {
        Bean<T> bean = this.getUniqueBean(javaClass, new Annotation[0]);
        AbstractComponent reference = (AbstractComponent)this.getCurrentManager().getReference(bean, javaClass, this.getCurrentManager().createCreationalContext(bean));
        AlterableContext context = (AlterableContext)this.getCurrentManager().getContext(bean.getScope());
        for (String string : VALUES) {
            Assert.assertNull((Object)reference.getValue());
            reference.setValue(string);
            Assert.assertEquals((String)reference.getValue(), (String)string);
            AbstractComponent.reset();
            context.destroy(bean);
            Assert.assertTrue((boolean)AbstractComponent.isDestroyed());
            Assert.assertNull((Object)reference.getValue(), (String)reference.getValue());
        }
    }
}

