/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.container.event;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.ejb.Stateless;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.SessionBeanType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.container.event.Cow;
import org.jboss.cdi.tck.tests.extensions.container.event.CowLocal;
import org.jboss.cdi.tck.tests.extensions.container.event.Farm;
import org.jboss.cdi.tck.tests.extensions.container.event.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.extensions.container.event.ProcessBeanObserver;
import org.jboss.cdi.tck.tests.extensions.container.event.ProcessInjectionTargetObserver;
import org.jboss.cdi.tck.tests.extensions.container.event.Sheep;
import org.jboss.cdi.tck.tests.extensions.container.event.SheepInterceptor;
import org.jboss.cdi.tck.tests.extensions.container.event.SheepLocal;
import org.jboss.cdi.tck.tests.extensions.container.event.Tame;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"javaee-full"})
@SpecVersion(spec="cdi", version="20091101")
public class ContainerEventTest
extends AbstractTest {
    @Deployment
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClassPackage(ContainerEventTest.class)).withExtensions(ProcessBeanObserver.class, ProcessInjectionTargetObserver.class, ProcessAnnotatedTypeObserver.class)).withEjbJarXml("ejb-jar.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_discovery", id="da"), @SpecAssertion(section="pit", id="aaa")})
    public void testProcessInjectionTargetFiredForManagedBean() {
        assert (ProcessInjectionTargetObserver.getManagedBeanEvent() != null);
        this.validateManagedBean((AnnotatedType<Farm>)ProcessInjectionTargetObserver.getManagedBeanEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pit", id="aab"), @SpecAssertion(section="pit", id="abb"), @SpecAssertion(section="bean_discovery", id="db")})
    public void testProcessInjectionTargetFiredForSessionBean() {
        assert (ProcessInjectionTargetObserver.getStatelessSessionBeanEvent() != null);
        assert (ProcessInjectionTargetObserver.getStatefulSessionBeanEvent() != null);
        this.validateStatelessSessionBean((Annotated)ProcessInjectionTargetObserver.getStatelessSessionBeanEvent().getAnnotatedType());
        this.validateStatefulSessionBean((Annotated)ProcessInjectionTargetObserver.getStatefulSessionBeanEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pit", id="aaf"), @SpecAssertion(section="pit", id="abf"), @SpecAssertion(section="bean_discovery", id="dh")})
    public void testProcessInjectionTargetFiredForSessionBeanInterceptor() {
        assert (ProcessInjectionTargetObserver.getSessionBeanInterceptorEvent() != null);
        this.validateSessionBeanInterceptor((AnnotatedType<SheepInterceptor>)ProcessInjectionTargetObserver.getSessionBeanInterceptorEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertion(section="bean_discovery", id="ba")
    public void testProcessAnnotatedTypeFiredForManagedBean() {
        assert (ProcessAnnotatedTypeObserver.getManagedBeanEvent() != null);
        this.validateManagedBean((AnnotatedType<Farm>)ProcessAnnotatedTypeObserver.getManagedBeanEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertion(section="bean_discovery", id="bb")
    public void testProcessAnnotatedTypeFiredForSessionBean() {
        assert (ProcessAnnotatedTypeObserver.getStatelessSessionBeanEvent() != null);
        assert (ProcessAnnotatedTypeObserver.getStatefulSessionBeanEvent() != null);
        this.validateStatelessSessionBean((Annotated)ProcessAnnotatedTypeObserver.getStatelessSessionBeanEvent().getAnnotatedType());
        this.validateStatefulSessionBean((Annotated)ProcessAnnotatedTypeObserver.getStatefulSessionBeanEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertion(section="bean_discovery", id="bh")
    public void testProcessAnnotatedTypeFiredForSessionBeanInterceptor() {
        assert (ProcessAnnotatedTypeObserver.getSessionBeanInterceptorEvent() != null);
        this.validateSessionBeanInterceptor((AnnotatedType<SheepInterceptor>)ProcessAnnotatedTypeObserver.getSessionBeanInterceptorEvent().getAnnotatedType());
    }

    @Test
    @SpecAssertion(section="pb", id="ba")
    public void testProcessManagedBeanFired() {
        assert (ProcessBeanObserver.getProcessManagedBeanEvent() != null);
        this.validateManagedBean((AnnotatedType<Farm>)ProcessBeanObserver.getProcessManagedBeanEvent().getAnnotatedBeanClass());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pb", id="ca"), @SpecAssertion(section="bean_discovery", id="fb")})
    public void testProcessSessionBeanFiredForStatelessSessionBean() {
        assert (ProcessBeanObserver.getProcessStatelessSessionBeanEvent() != null);
        this.validateStatelessSessionBean((Annotated)ProcessBeanObserver.getProcessStatelessSessionBeanEvent().getAnnotatedBeanClass());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pb", id="ca"), @SpecAssertion(section="bean_discovery", id="fb")})
    public void testProcessSessionBeanFiredForStatefulSessionBean() {
        assert (ProcessBeanObserver.getProcessStatefulSessionBeanEvent() != null);
        this.validateStatefulSessionBean((Annotated)ProcessBeanObserver.getProcessStatefulSessionBeanEvent().getAnnotatedBeanClass());
    }

    @Test
    @SpecAssertion(section="pb", id="hb")
    public void testGetEJBName() {
        assert (ProcessBeanObserver.getProcessStatelessSessionBeanEvent().getEjbName().equals("sheep"));
        assert (ProcessBeanObserver.getProcessStatefulSessionBeanEvent().getEjbName().equals("cow"));
    }

    @Test
    @SpecAssertion(section="pb", id="hc")
    public void testGetSessionBeanType() {
        assert (ProcessBeanObserver.getProcessStatelessSessionBeanEvent().getSessionBeanType().equals((Object)SessionBeanType.STATELESS));
        assert (ProcessBeanObserver.getProcessStatefulSessionBeanEvent().getSessionBeanType().equals((Object)SessionBeanType.STATEFUL));
    }

    private void validateStatelessSessionBean(Annotated type) {
        assert (type.getBaseType().equals(Sheep.class));
        assert (this.rawTypeSetMatches(type.getTypeClosure(), Sheep.class, SheepLocal.class, Object.class));
        assert (type.getAnnotations().size() == 2);
        assert (this.annotationSetMatches((Set<? extends Annotation>)type.getAnnotations(), Tame.class, Stateless.class));
    }

    private void validateStatefulSessionBean(Annotated type) {
        assert (type.getBaseType().equals(Cow.class));
        assert (this.rawTypeSetMatches(type.getTypeClosure(), Cow.class, CowLocal.class, Object.class));
        assert (type.getAnnotations().size() == 0);
    }

    private void validateSessionBeanInterceptor(AnnotatedType<SheepInterceptor> type) {
        assert (type.getBaseType().equals(SheepInterceptor.class));
        assert (this.rawTypeSetMatches(type.getTypeClosure(), SheepInterceptor.class, Object.class));
        assert (type.getAnnotations().size() == 0);
        assert (type.getFields().size() == 0);
        assert (type.getMethods().size() == 1);
    }

    private void validateManagedBean(AnnotatedType<Farm> type) {
        assert (type.getBaseType().equals(Farm.class));
        assert (this.rawTypeSetMatches(type.getTypeClosure(), Farm.class, Object.class));
        assert (type.getFields().size() == 1);
        assert (((AnnotatedField)type.getFields().iterator().next()).isAnnotationPresent(Produces.class));
        assert (type.getMethods().size() == 1);
        assert (((AnnotatedMethod)type.getMethods().iterator().next()).isAnnotationPresent(Produces.class));
    }
}

