/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.async;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ApplicationContextAsyncListenerTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ApplicationContextAsyncListenerTest.class)).build();
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="application_context", id="ae")
    public void testApplicationContextActiveOnComplete() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page = (TextPage)webClient.getPage(this.getPath("complete"));
        Assert.assertTrue((boolean)page.getContent().contains("onTimeout: null"));
        Assert.assertTrue((boolean)page.getContent().contains("onError: null"));
        Assert.assertFalse((boolean)page.getContent().contains("onComplete: null"));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="application_context", id="ae")
    public void testApplicationContextActiveOnTimeout() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(false);
        TextPage page = (TextPage)webClient.getPage(this.getPath("timeout"));
        Assert.assertTrue((boolean)page.getContent().contains("onTimeout:"));
        Assert.assertFalse((boolean)page.getContent().contains("onTimeout: null"));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="application_context", id="ae")
    public void testApplicationContextActiveOnError() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(false);
        TextPage page = (TextPage)webClient.getPage(this.getPath("error"));
        Assert.assertTrue((boolean)page.getContent().contains("onError:"));
        Assert.assertFalse((boolean)page.getContent().contains("onError: null"));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="application_context", id="ae")
    public void testApplicationContextActiveOnStartAsync() throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page = (TextPage)webClient.getPage(this.getPath("loop"));
        Assert.assertFalse((boolean)page.getContent().contains("onStartAsync: null"));
        Assert.assertFalse((boolean)page.getContent().contains("onComplete: null"));
    }

    private String getPath(String test) {
        return this.contextPath + "AsyncServlet?test=" + test;
    }
}

