/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.parameterized;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.parameterized.Bar;
import org.jboss.cdi.tck.tests.event.parameterized.Baz;
import org.jboss.cdi.tck.tests.event.parameterized.Blah;
import org.jboss.cdi.tck.tests.event.parameterized.EventObserver;
import org.jboss.cdi.tck.tests.event.parameterized.Foo;
import org.jboss.cdi.tck.tests.event.parameterized.IntegerListObserver;
import org.jboss.cdi.tck.tests.event.parameterized.StringListObserver;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="20091101")
public class ParameterizedEventTest
extends AbstractTest {
    @Inject
    private Event<Object> event;
    @Inject
    private Event<Foo<List<Integer>>> integerListFooEvent;
    @Inject
    private Event<Bar<List<Integer>>> integerListBarEvent;
    @Inject
    private EventObserver observer;
    @Inject
    private IntegerListObserver integerObserver;
    @Inject
    private StringListObserver stringObserver;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ParameterizedEventTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="event", id="edb")})
    public void testSelectedEventTypeUsedForResolvingEventTypeArguments() {
        this.reset();
        this.integerListBarEvent.fire(new Bar());
        Assert.assertTrue((boolean)this.observer.isIntegerListFooableObserved());
        Assert.assertTrue((boolean)this.observer.isIntegerListFooObserved());
        Assert.assertTrue((boolean)this.observer.isIntegerListBarObserved());
        Assert.assertFalse((boolean)this.observer.isBazObserved());
        Assert.assertFalse((boolean)this.observer.isStringListFooableObserved());
        Assert.assertTrue((boolean)this.integerObserver.isFooableObserved());
        Assert.assertTrue((boolean)this.integerObserver.isFooObserved());
        Assert.assertTrue((boolean)this.integerObserver.isBarObserved());
        Assert.assertFalse((boolean)this.stringObserver.isFooableObserved());
        Assert.assertFalse((boolean)this.stringObserver.isFooObserved());
        Assert.assertFalse((boolean)this.stringObserver.isBarObserved());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="event", id="edb")})
    public void testSelectedEventTypeUsedForResolvingEventTypeArguments2() {
        this.reset();
        Event selectedEvent = this.event.select((TypeLiteral)new TypeLiteral<Foo<List<Integer>>>(){}, new Annotation[0]);
        selectedEvent.fire(new Foo());
        Assert.assertTrue((boolean)this.observer.isIntegerListFooableObserved());
        Assert.assertTrue((boolean)this.observer.isIntegerListFooObserved());
        Assert.assertFalse((boolean)this.observer.isIntegerListBarObserved());
        Assert.assertFalse((boolean)this.observer.isBazObserved());
        Assert.assertFalse((boolean)this.observer.isStringListFooableObserved());
        Assert.assertTrue((boolean)this.integerObserver.isFooableObserved());
        Assert.assertTrue((boolean)this.integerObserver.isFooObserved());
        Assert.assertFalse((boolean)this.integerObserver.isBarObserved());
        Assert.assertFalse((boolean)this.stringObserver.isFooableObserved());
        Assert.assertFalse((boolean)this.stringObserver.isFooObserved());
        Assert.assertFalse((boolean)this.stringObserver.isBarObserved());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="event", id="edb")})
    public void testSelectedEventTypeCombinedWithEventObjectRuntimeTypeForResolvingEventTypeArguments() {
        this.reset();
        Event selectedEvent = this.event.select((TypeLiteral)new TypeLiteral<Foo<List<Integer>>>(){}, new Annotation[0]);
        selectedEvent.fire(new Bar());
        Assert.assertTrue((boolean)this.observer.isIntegerListFooableObserved());
        Assert.assertTrue((boolean)this.observer.isIntegerListFooObserved());
        Assert.assertTrue((boolean)this.observer.isIntegerListBarObserved());
        Assert.assertFalse((boolean)this.observer.isBazObserved());
        Assert.assertFalse((boolean)this.observer.isStringListFooableObserved());
        Assert.assertTrue((boolean)this.integerObserver.isFooableObserved());
        Assert.assertTrue((boolean)this.integerObserver.isFooObserved());
        Assert.assertTrue((boolean)this.integerObserver.isBarObserved());
        Assert.assertFalse((boolean)this.stringObserver.isFooableObserved());
        Assert.assertFalse((boolean)this.stringObserver.isFooObserved());
        Assert.assertFalse((boolean)this.stringObserver.isBarObserved());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="event", id="edb")})
    public void testSelectedEventTypeCombinedWithEventObjectRuntimeTypeForResolvingEventTypeArguments2() {
        this.reset();
        Event selectedEvent = this.event.select((TypeLiteral)new TypeLiteral<List<Character>>(){}, new Annotation[0]);
        selectedEvent.fire(new ArrayList());
        Assert.assertTrue((boolean)this.observer.isCharacterListObserved());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observers_assignability", id="d")})
    public void testEventObjectTypeUsed() {
        this.reset();
        this.integerListBarEvent.fire((Object)new Baz());
        Assert.assertTrue((boolean)this.observer.isIntegerListFooableObserved());
        Assert.assertTrue((boolean)this.observer.isIntegerListFooObserved());
        Assert.assertTrue((boolean)this.observer.isIntegerListBarObserved());
        Assert.assertTrue((boolean)this.observer.isBazObserved());
        Assert.assertFalse((boolean)this.observer.isStringListFooableObserved());
        Assert.assertTrue((boolean)this.integerObserver.isFooableObserved());
        Assert.assertTrue((boolean)this.integerObserver.isFooObserved());
        Assert.assertTrue((boolean)this.integerObserver.isBarObserved());
        Assert.assertFalse((boolean)this.stringObserver.isFooableObserved());
        Assert.assertFalse((boolean)this.stringObserver.isFooObserved());
        Assert.assertFalse((boolean)this.stringObserver.isBarObserved());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="event", id="f")})
    public void testUnresolvedTypeVariableDetected1() {
        try {
            this.integerListFooEvent.fire(new Blah());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="event", id="f")})
    public <T> void testUnresolvedTypeVariableDetected2() {
        try {
            this.event.select(new TypeLiteral<Map<Exception, T>>(){}, new Annotation[0]).fire(new HashMap());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="event", id="f")})
    public <T> void testUnresolvedTypeVariableDetected3() {
        try {
            this.event.select(new TypeLiteral<ArrayList<List<List<List<T>>>>>(){}, new Annotation[0]).fire(new ArrayList());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void reset() {
        this.observer.reset();
        this.integerObserver.reset();
        this.stringObserver.reset();
    }
}

