/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.bootstrap.unavailable.methods;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.cdi.tck.tests.extensions.beanManager.bootstrap.unavailable.methods.Foo;
import org.jboss.cdi.tck.tests.extensions.beanManager.bootstrap.unavailable.methods.Transactional;
import org.testng.Assert;

public class WrongExtension
implements Extension {
    private Bean<Foo> fooBean;
    private InjectionPoint injectionPoint;

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        this.testUnavailableMethods(beanManager);
    }

    public void observeProcessBean(@Observes ProcessBean<Foo> event, BeanManager beanManager) {
        this.fooBean = event.getBean();
        this.testUnavailableMethods(beanManager);
    }

    public void observeAfterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        this.testUnavailableMethods(beanManager);
    }

    public void observeInjectionPoint(@Observes ProcessInjectionPoint<?, ?> event) {
        if (this.injectionPoint == null) {
            this.injectionPoint = event.getInjectionPoint();
        }
    }

    public void validate(@Observes AfterDeploymentValidation event, BeanManager manager) {
        this.testAvailableMethods(manager);
    }

    private void testUnavailableMethods(BeanManager beanManager) {
        if (this.fooBean != null) {
            try {
                beanManager.getReference(this.fooBean, Foo.class, null);
                Assert.fail((String)"getReference() must not be available");
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        try {
            beanManager.getBeans("foo");
            Assert.fail((String)"getBeans() must not be available");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            beanManager.getBeans(Foo.class, new Annotation[0]);
            Assert.fail((String)"getBeans() must not be available");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            beanManager.getInjectableReference(beanManager.createInjectionPoint((AnnotatedField)beanManager.createAnnotatedType(Foo.class).getFields().iterator().next()), null);
            Assert.fail((String)"getInjectableReference() must not be available");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            beanManager.resolve(null);
            Assert.fail((String)"resolve() must not be available");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            beanManager.resolveObserverMethods((Object)new Foo(), new Annotation[0]);
            Assert.fail((String)"resolveObserverMethods() must not be available");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<Transactional>(){}});
            Assert.fail((String)"resolveInterceptors() must not be available");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            beanManager.resolveDecorators(new HashSet<Class>(Arrays.asList(Foo.class)), new Annotation[0]);
            Assert.fail((String)"resolveDecorators() must not be available");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            beanManager.validate((InjectionPoint)new FooInjectionPoint());
            Assert.fail((String)"validate() must not be available");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            beanManager.getPassivationCapableBean("foo");
            Assert.fail((String)"getPassivationCapableBean() must not be available");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void testAvailableMethods(BeanManager beanManager) {
        beanManager.getReference((Bean)new FooBean(), Foo.class, beanManager.createCreationalContext(null));
        beanManager.getBeans("foo");
        beanManager.getBeans(Foo.class, new Annotation[0]);
        beanManager.getInjectableReference(beanManager.createInjectionPoint((AnnotatedField)beanManager.createAnnotatedType(Foo.class).getFields().iterator().next()), beanManager.createCreationalContext(null));
        beanManager.resolve(null);
        beanManager.resolveObserverMethods((Object)new Foo(), new Annotation[0]);
        beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<Transactional>(){}});
        beanManager.resolveDecorators(new HashSet<Class>(Arrays.asList(Foo.class)), new Annotation[0]);
        beanManager.validate(this.injectionPoint);
        beanManager.getPassivationCapableBean("foo");
    }

    private static class FooInjectionPoint
    implements InjectionPoint {
        private FooInjectionPoint() {
        }

        public boolean isTransient() {
            return false;
        }

        public boolean isDelegate() {
            return false;
        }

        public Type getType() {
            return Foo.class;
        }

        public Set<Annotation> getQualifiers() {
            return null;
        }

        public Member getMember() {
            return null;
        }

        public Bean<?> getBean() {
            return null;
        }

        public Annotated getAnnotated() {
            return null;
        }
    }

    private static class FooBean
    implements Bean<Foo> {
        private FooBean() {
        }

        public Class<?> getBeanClass() {
            return Foo.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public boolean isNullable() {
            return false;
        }

        public Set<Type> getTypes() {
            HashSet<Type> set = new HashSet<Type>();
            set.add((Type)((Object)Foo.class));
            return set;
        }

        public Set<Annotation> getQualifiers() {
            return Collections.emptySet();
        }

        public Class<? extends Annotation> getScope() {
            return Dependent.class;
        }

        public String getName() {
            return null;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public Foo create(CreationalContext<Foo> creationalContext) {
            return null;
        }

        public void destroy(Foo instance, CreationalContext<Foo> creationalContext) {
        }
    }
}

