/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.cdi.tck.tests.deployment.initialization;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

import org.jboss.cdi.tck.util.ActionSequence;

/**
 *
 * @author Martin Kouba
 */
public class LifecycleMonitoringExtension implements Extension {

    public LifecycleMonitoringExtension() {
        ActionSequence.addAction(LifecycleMonitoringExtension.class.getName());
    }

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery event) {
        ActionSequence.addAction(BeforeBeanDiscovery.class.getName());
    }

    public void observeAfterTypeDiscovery(@Observes AfterTypeDiscovery event) {
        ActionSequence.addAction(AfterTypeDiscovery.class.getName());
    }

    public void observeAfterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        ActionSequence.addAction(AfterBeanDiscovery.class.getName());
    }

    public void observeAfterDeploymentValidation(@Observes AfterDeploymentValidation event) {
        ActionSequence.addAction(AfterDeploymentValidation.class.getName());
    }

    public void observeBeanDiscovery(@Observes ProcessAnnotatedType<Foo> event) {
        // We only need to check bean discovery occured in specific sequence
        ActionSequence.addAction(ProcessAnnotatedType.class.getName());
    }

}
