/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.FastAndDeadlyMissile;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.GuidedMissile;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.LockInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.Missile;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.MissileInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.multipleBindings.SlowMissile;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class MultipleInterceptorBindingsTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MultipleInterceptorBindingsTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test(groups={"interceptorsSpec"})
    public void testInterceptorAppliedToBeanWithAllBindings() {
        MissileInterceptor.intercepted = false;
        Missile missile = this.getContextualReference(FastAndDeadlyMissile.class, new Annotation[0]);
        missile.fire();
        assert (MissileInterceptor.intercepted);
    }

    @Test(groups={"interceptorsSpec"})
    public void testInterceptorNotAppliedToBeanWithSomeBindings() {
        MissileInterceptor.intercepted = false;
        Missile missile = this.getContextualReference(SlowMissile.class, new Annotation[0]);
        missile.fire();
        assert (!MissileInterceptor.intercepted);
    }

    @Test(groups={"interceptorsSpec"})
    public void testMultipleInterceptorsOnMethod() {
        LockInterceptor.intercepted = false;
        GuidedMissile bullet = this.getContextualReference(GuidedMissile.class, new Annotation[0]);
        bullet.fire();
        assert (!LockInterceptor.intercepted);
        bullet.lockAndFire();
        assert (LockInterceptor.intercepted);
    }
}

