/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.impl.testng;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;

public class SingleTestClassMethodInterceptor
implements IMethodInterceptor {
    public static final String TEST_CLASS_PROPERTY = "tckTest";
    private final Logger logger = Logger.getLogger(SingleTestClassMethodInterceptor.class.getName());

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        if (methods == null || methods.isEmpty()) {
            return methods;
        }
        this.logger.log(Level.INFO, "Intercepting... [methods: {0}, testRun: {1}, suiteName: {2}]", new Object[]{methods.size(), context.getName(), context.getSuite().getName()});
        long start = System.currentTimeMillis();
        String testString = System.getProperty(TEST_CLASS_PROPERTY);
        if (testString == null || testString.isEmpty()) {
            Collections.sort(methods, new MethodComparator());
            this.logger.log(Level.INFO, "tckTest not set [time: {0} ms]", System.currentTimeMillis() - start);
            return methods;
        }
        ArrayList<IMethodInstance> methodsToRun = new ArrayList<IMethodInstance>();
        String testClass = null;
        HashSet<String> testMethodsSet = new HashSet<String>();
        if (testString.contains("#")) {
            testClass = testString.split("#")[0];
            String[] testMethod = testString.split("#")[1].split("\\+");
            testMethodsSet.addAll(Arrays.asList(testMethod));
        } else {
            testClass = testString;
        }
        if (testClass.contains(".")) {
            for (IMethodInstance method : methods) {
                if (!method.getMethod().getTestClass().getName().equals(testClass) || !testMethodsSet.isEmpty() && !testMethodsSet.contains(method.getMethod().getMethodName())) continue;
                methodsToRun.add(method);
            }
        } else {
            for (IMethodInstance method : methods) {
                if (!method.getMethod().getTestClass().getName().endsWith("." + testClass) || !testMethodsSet.isEmpty() && !testMethodsSet.contains(method.getMethod().getMethodName())) continue;
                methodsToRun.add(method);
            }
        }
        Collections.sort(methodsToRun, new MethodComparator());
        this.logger.log(Level.INFO, "tckTest set to {0} [methods: {1}, time: {2} ms]", new Object[]{testClass, methodsToRun.size(), System.currentTimeMillis() - start});
        return methodsToRun;
    }

    private final class MethodComparator
    implements Comparator<IMethodInstance> {
        private MethodComparator() {
        }

        @Override
        public int compare(IMethodInstance o1, IMethodInstance o2) {
            int result = o1.getMethod().getTestClass().getName().compareTo(o2.getMethod().getTestClass().getName());
            return result;
        }
    }
}

