/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.overriden.wrapped;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.overriden.wrapped.Bird;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.overriden.wrapped.Eagle;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.overriden.wrapped.Falcon;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.overriden.wrapped.WrappingExtension;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="int", version="3.1.PFD")
public class OverridenLifecycleCallbackInterceptorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(OverridenLifecycleCallbackInterceptorTest.class)).withExtension(WrappingExtension.class)).build();
    }

    @Test
    @SpecAssertion(section="5.1", id="g")
    public void testCallbackOverridenByCallback() {
        Bird.reset();
        Eagle.reset();
        Bean<Eagle> fooBean = this.getUniqueBean(Eagle.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(fooBean);
        Eagle foo = (Eagle)fooBean.create(ctx);
        foo.ping();
        fooBean.destroy((Object)foo, ctx);
        Assert.assertEquals((int)Bird.getInitBirdCalled().get(), (int)0);
        Assert.assertEquals((int)Eagle.getInitEagleCalled().get(), (int)1);
        Assert.assertEquals((int)Bird.getDestroyBirdCalled().get(), (int)0);
        Assert.assertEquals((int)Eagle.getDestroyEagleCalled().get(), (int)1);
    }

    @Test
    @SpecAssertion(section="5.1", id="g")
    public void testCallbackOverridenByNonCallback() {
        Bird.reset();
        Falcon.reset();
        Bean<Falcon> bazBean = this.getUniqueBean(Falcon.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bazBean);
        Falcon baz = (Falcon)bazBean.create(ctx);
        baz.ping();
        bazBean.destroy((Object)baz, ctx);
        Assert.assertEquals((int)Bird.getInitBirdCalled().get(), (int)0);
        Assert.assertEquals((int)Falcon.getInitFalconCalled().get(), (int)0);
        Assert.assertEquals((int)Bird.getDestroyBirdCalled().get(), (int)0);
        Assert.assertEquals((int)Falcon.getDestroyFalconCalled().get(), (int)0);
    }
}

