/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.event.timeout;

import java.io.IOException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.cdi.tck.tests.context.request.event.timeout.ApplicationScopedObserver;
import org.jboss.cdi.tck.tests.context.request.event.timeout.TimeoutService;
import org.jboss.cdi.tck.util.Timer;

@WebServlet(value={"/info"})
public class InfoServlet
extends HttpServlet {
    private final ApplicationScopedObserver observingBean;
    @Inject
    TimeoutService timeoutService;

    @Inject
    public InfoServlet(ApplicationScopedObserver observingBean) {
        this.observingBean = observingBean;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Boolean initializedResult;
        SynchronousQueue<Boolean> queue = new SynchronousQueue<Boolean>();
        this.timeoutService.start(queue);
        try {
            initializedResult = queue.poll(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ServletException((Throwable)e);
        }
        resp.getWriter().append("Initialized:" + initializedResult);
        resp.getWriter().append("\n");
        try {
            new Timer().setDelay(2000L).addStopCondition(new Timer.StopCondition(){

                @Override
                public boolean isSatisfied() {
                    return InfoServlet.this.observingBean.isDestroyedCalled();
                }
            }).start();
        }
        catch (InterruptedException e) {
            throw new ServletException((Throwable)e);
        }
        resp.getWriter().append("Destroyed:" + this.observingBean.isDestroyedCalled());
        resp.setContentType("text/plain");
    }
}

