/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.context.DummyScoped;
import org.jboss.cdi.tck.tests.context.Unregistered;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class ContextTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ContextTest.class)).withExtension(AfterBeanDiscoveryObserver.class)).build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertion(section="active_context", id="b")
    public void testGetContextWithTooManyActiveContextsFails() {
        this.getCurrentManager().getContext(DummyScoped.class);
    }

    @Test(expectedExceptions={ContextNotActiveException.class})
    @SpecAssertion(section="active_context", id="a")
    public void testGetContextWithNoRegisteredContextsFails() {
        this.getCurrentManager().getContext(Unregistered.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtin_scopes", id="aa"), @SpecAssertion(section="builtin_scopes", id="ab"), @SpecAssertion(section="builtin_scopes", id="ac"), @SpecAssertion(section="builtin_scopes", id="ca"), @SpecAssertion(section="bm_obtain_active_context", id="a")})
    public void testBuiltInContexts() {
        Context context = this.getCurrentManager().getContext(Dependent.class);
        assert (context != null);
        context = this.getCurrentManager().getContext(RequestScoped.class);
        assert (context != null);
        context = this.getCurrentManager().getContext(SessionScoped.class);
        assert (context != null);
        context = this.getCurrentManager().getContext(ApplicationScoped.class);
        assert (context != null);
    }
}

