/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.filter;

import java.io.IOException;
import javax.enterprise.context.Conversation;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.cdi.tck.tests.context.conversation.filter.Dummy;
import org.jboss.cdi.tck.tests.context.conversation.filter.State;
import org.jboss.cdi.tck.tests.context.conversation.filter.Tester;
import org.jboss.cdi.tck.util.SimpleLogger;

@WebServlet(value={"/introspect"})
public class IntrospectServlet
extends HttpServlet {
    private static final SimpleLogger logger = new SimpleLogger(IntrospectServlet.class);
    public static final String MODE_INIT = "init";
    public static final String MODE_INSPECT = "inspect";
    public static final String MODE_LONG_TASK = "long_task";
    public static final String MODE_BUSY_REQUEST = "busy_request";
    public static final long LONG_TASK_TIMEOUT = 10000L;
    @Inject
    Dummy dummy;
    @Inject
    Conversation conversation;
    @Inject
    Tester tester;
    @Inject
    State state;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        String mode = req.getParameter("mode");
        if (MODE_INIT.equals(mode)) {
            this.conversation.begin();
            this.dummy.ping();
            this.state.reset();
            resp.getWriter().write(this.conversation.getId() + "::" + req.getSession().getId());
        } else if (MODE_INSPECT.equals(mode)) {
            if (this.conversation.isTransient()) {
                resp.sendError(500, "No long running conversation");
            } else {
                resp.getWriter().write("" + this.tester.getResult());
            }
        } else if (MODE_LONG_TASK.equals(mode)) {
            if (this.conversation.isTransient()) {
                resp.sendError(500, "No long running conversation");
            } else {
                long start = System.currentTimeMillis();
                while (!this.state.isBusyAttemptMade() && System.currentTimeMillis() - start < 10000L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException();
                    }
                }
                logger.log("Long task finished [isBusyAttemptMade: {0}, time: {1} ms]", this.state.isBusyAttemptMade(), System.currentTimeMillis() - start);
                resp.getWriter().write("OK");
            }
        } else if (MODE_BUSY_REQUEST.equals(mode)) {
            resp.sendError(500, "BusyConversationException should be thrown");
        } else {
            throw new ServletException("Unknown test mode");
        }
    }
}

