/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.disposal.method.definition;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.Calisoga;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.Deadliest;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.DisposalNonBean;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.SandSpider;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.Scary;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.SpiderProducer;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.Tame;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.Tarantula;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.WebSpider;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.Widow;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class DisposalMethodDefinitionTest
extends AbstractTest {
    private static final Annotation DEADLIEST_LITERAL = new AnnotationLiteral<Deadliest>(){};
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DisposalMethodDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="method_constructor_parameter_qualifiers", id="c"), @SpecAssertion(section="disposer_method", id="b"), @SpecAssertion(section="disposer_method", id="c"), @SpecAssertion(section="disposer_method", id="e"), @SpecAssertion(section="disposer_method_disposed_parameter", id="ba"), @SpecAssertion(section="declaring_disposer_method", id="a"), @SpecAssertion(section="declaring_disposer_method", id="b0"), @SpecAssertion(section="disposer_method_resolution", id="aa"), @SpecAssertion(section="producer_or_disposer_methods_invocation", id="b")})
    public void testBindingTypesAppliedToDisposalMethodParameters() throws Exception {
        Assert.assertFalse((boolean)SpiderProducer.isTameSpiderDestroyed());
        Assert.assertFalse((boolean)SpiderProducer.isDeadliestTarantulaDestroyed());
        Bean<Tarantula> tarantula = this.getBeans(Tarantula.class, DEADLIEST_LITERAL).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(tarantula);
        Tarantula instance = (Tarantula)tarantula.create(creationalContext);
        tarantula.destroy((Object)instance, creationalContext);
        Assert.assertTrue((boolean)SpiderProducer.isTameSpiderDestroyed());
        Assert.assertTrue((boolean)SpiderProducer.isDeadliestTarantulaDestroyed());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="disposer_method", id="aa"), @SpecAssertion(section="disposer_method_disposed_parameter", id="ba")})
    public void testDisposalMethodOnNonBean() throws Exception {
        Bean<WebSpider> webSpider = this.getBeans(WebSpider.class, DEADLIEST_LITERAL).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(webSpider);
        WebSpider instance = (WebSpider)this.getCurrentManager().getContext(webSpider.getScope()).get(webSpider);
        webSpider.destroy((Object)instance, creationalContext);
        assert (!DisposalNonBean.isWebSpiderdestroyed());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_disposer_method", id="h"), @SpecAssertion(section="injection_point_default_qualifier", id="a"), @SpecAssertion(section="producer_or_disposer_methods_invocation", id="e")})
    public void testDisposalMethodParametersGetInjected() throws Exception {
        Bean<SandSpider> sandSpider = this.getBeans(SandSpider.class, DEADLIEST_LITERAL).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(sandSpider);
        SandSpider instance = (SandSpider)this.getCurrentManager().getContext(sandSpider.getScope()).get(sandSpider);
        sandSpider.destroy((Object)instance, creationalContext);
        assert (SpiderProducer.isDeadliestSandSpiderDestroyed());
    }

    @Test
    @SpecAssertion(section="disposer_method_disposed_parameter", id="da")
    public void testDisposalMethodForMultipleProducerMethods() throws Exception {
        Bean<Widow> deadliest = this.getBeans(Widow.class, DEADLIEST_LITERAL).iterator().next();
        CreationalContext deadliestCreationalContext = this.getCurrentManager().createCreationalContext(deadliest);
        Widow deadliestInstance = (Widow)this.getCurrentManager().getContext(deadliest.getScope()).get(deadliest);
        deadliest.destroy((Object)deadliestInstance, deadliestCreationalContext);
        Bean<Widow> tame = this.getBeans(Widow.class, TAME_LITERAL).iterator().next();
        CreationalContext tameCreationalContext = this.getCurrentManager().createCreationalContext(tame);
        Widow tameInstance = (Widow)this.getCurrentManager().getContext(deadliest.getScope()).get(tame);
        tame.destroy((Object)tameInstance, tameCreationalContext);
        Assert.assertEquals((int)SpiderProducer.getWidowsDestroyed(), (int)2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="disposer_method_resolution", id="ab"), @SpecAssertion(section="producer_field_lifecycle", id="o")})
    public void testDisposalMethodCalledForProducerField() throws Exception {
        this.createAndDestroyBean(Calisoga.class, new Scary.Literal());
        Assert.assertTrue((boolean)SpiderProducer.isScaryBlackWidowDestroyed());
        Assert.assertFalse((boolean)SpiderProducer.isTameBlackWidowDestroyed());
        SpiderProducer.reset();
        this.createAndDestroyBean(Calisoga.class, TAME_LITERAL);
        Assert.assertFalse((boolean)SpiderProducer.isScaryBlackWidowDestroyed());
        Assert.assertTrue((boolean)SpiderProducer.isTameBlackWidowDestroyed());
    }

    private <T> void createAndDestroyBean(Class<T> type, Annotation ... qualifiers) {
        Bean<T> bean = this.getBeans(type, qualifiers).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        Object instance = bean.create(creationalContext);
        bean.destroy(instance, creationalContext);
    }
}

