/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.lifecycleCallback;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.jboss.cdi.tck.interceptors.tests.lifecycleCallback.Animal;

public class AnimalInterceptor {
    private static Set<String> postConstructInterceptorCalledFor = new HashSet<String>();
    private static Set<String> preDestroyInterceptorCalledFor = new HashSet<String>();

    @PostConstruct
    public void postConstruct(InvocationContext ctx) {
        postConstructInterceptorCalledFor.add(((Animal)ctx.getTarget()).getAnimalType());
        try {
            ctx.proceed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        if (ctx.getMethod().getName().equals("echo")) {
            return ctx.proceed() + ctx.getParameters()[0].toString();
        }
        return ctx.proceed();
    }

    @PreDestroy
    public void preDestroy(InvocationContext ctx) {
        preDestroyInterceptorCalledFor.add(((Animal)ctx.getTarget()).getAnimalType());
        try {
            ctx.proceed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPostConstructInterceptorCalled(String animalType) {
        return postConstructInterceptorCalledFor.contains(animalType);
    }

    public static boolean isPreDestroyInterceptorCalled(String animalType) {
        return preDestroyInterceptorCalledFor.contains(animalType);
    }
}

