/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.dynamic.AdvancedPaymentProcessor;
import org.jboss.cdi.tck.tests.lookup.dynamic.AsynchronousPaymentProcessor;
import org.jboss.cdi.tck.tests.lookup.dynamic.NonBinding;
import org.jboss.cdi.tck.tests.lookup.dynamic.ObtainsInstanceBean;
import org.jboss.cdi.tck.tests.lookup.dynamic.ObtainsNewInstanceBean;
import org.jboss.cdi.tck.tests.lookup.dynamic.PayBy;
import org.jboss.cdi.tck.tests.lookup.dynamic.PayByBinding;
import org.jboss.cdi.tck.tests.lookup.dynamic.PaymentProcessor;
import org.jboss.cdi.tck.tests.lookup.dynamic.RemotePaymentProcessor;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class DynamicLookupTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DynamicLookupTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="programmatic_lookup", id="aa")})
    public void testObtainsInjectsInstanceOfInstance() {
        ObtainsInstanceBean injectionPoint = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]);
        assert (injectionPoint.getPaymentProcessor() != null);
    }

    @Test
    @SpecAssertion(section="dynamic_lookup", id="da")
    public void testDuplicateBindingsThrowsException() {
        try {
            ObtainsInstanceBean injectionPoint = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]);
            injectionPoint.getAnyPaymentProcessor().select(new Annotation[]{new PayByBinding(PayBy.PaymentMethod.CASH){}, new PayByBinding(PayBy.PaymentMethod.CREDIT_CARD){}});
        }
        catch (Throwable t) {
            assert (this.isThrowablePresent(IllegalArgumentException.class, t));
            return;
        }
        assert (false);
    }

    @Test
    @SpecAssertion(section="dynamic_lookup", id="e")
    public void testNonBindingThrowsException() {
        try {
            ObtainsInstanceBean injectionPoint = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]);
            injectionPoint.getAnyPaymentProcessor().select(new Annotation[]{new AnnotationLiteral<NonBinding>(){}});
        }
        catch (Throwable t) {
            assert (this.isThrowablePresent(IllegalArgumentException.class, t));
            return;
        }
        assert (false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="programmatic_lookup", id="ba"), @SpecAssertion(section="programmatic_lookup", id="ca"), @SpecAssertion(section="dynamic_lookup", id="aa"), @SpecAssertion(section="dynamic_lookup", id="ab"), @SpecAssertion(section="dynamic_lookup", id="fa"), @SpecAssertion(section="dynamic_lookup", id="fc")})
    public void testGetMethod() {
        this.getContextualReference(AdvancedPaymentProcessor.class, new Annotation[]{AnyLiteral.INSTANCE}).setValue(10);
        Instance<AsynchronousPaymentProcessor> instance = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]).getPaymentProcessor();
        assert (instance.get() instanceof AdvancedPaymentProcessor);
        assert (((AsynchronousPaymentProcessor)instance.get()).getValue() == 10);
    }

    @Test
    @SpecAssertion(section="dynamic_lookup", id="fba")
    public void testUnsatisfiedDependencyThrowsException() {
        try {
            this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]).getPaymentProcessor().select(RemotePaymentProcessor.class, new Annotation[0]).get();
        }
        catch (Throwable t) {
            assert (this.isThrowablePresent(UnsatisfiedResolutionException.class, t));
            return;
        }
        assert (false);
    }

    @Test
    @SpecAssertion(section="dynamic_lookup", id="fbb")
    public void testAmbiguousDependencyThrowsException() {
        try {
            this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]).getAnyPaymentProcessor().get();
        }
        catch (Throwable t) {
            assert (this.isThrowablePresent(AmbiguousResolutionException.class, t));
            return;
        }
        assert (false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="dynamic_lookup", id="aa"), @SpecAssertion(section="dynamic_lookup", id="ba"), @SpecAssertion(section="dynamic_lookup", id="ja"), @SpecAssertion(section="dynamic_lookup", id="ka"), @SpecAssertion(section="annotationliteral_typeliteral", id="a")})
    public void testIteratorMethod() {
        this.getContextualReference(AdvancedPaymentProcessor.class, new Annotation[]{AnyLiteral.INSTANCE}).setValue(1);
        this.getContextualReference(RemotePaymentProcessor.class, new Annotation[]{AnyLiteral.INSTANCE}).setValue(2);
        Instance<PaymentProcessor> instance = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]).getAnyPaymentProcessor();
        Iterator iterator1 = instance.select(AsynchronousPaymentProcessor.class, new Annotation[0]).iterator();
        AdvancedPaymentProcessor advanced = null;
        RemotePaymentProcessor remote = null;
        int instances = 0;
        while (iterator1.hasNext()) {
            PaymentProcessor processor = (PaymentProcessor)iterator1.next();
            if (processor instanceof AdvancedPaymentProcessor) {
                advanced = (AdvancedPaymentProcessor)processor;
            } else if (processor instanceof RemotePaymentProcessor) {
                remote = (RemotePaymentProcessor)processor;
            } else {
                throw new RuntimeException("Unexpected instance returned by iterator.");
            }
            ++instances;
        }
        assert (instances == 2);
        assert (advanced != null);
        assert (advanced.getValue() == 1);
        assert (remote != null);
        assert (remote.getValue() == 2);
        Iterator iterator2 = instance.select(RemotePaymentProcessor.class, new Annotation[]{new PayByBinding(PayBy.PaymentMethod.CREDIT_CARD){}}).iterator();
        assert (((RemotePaymentProcessor)iterator2.next()).getValue() == 2);
        assert (!iterator2.hasNext());
    }

    @Test
    @SpecAssertion(section="dynamic_lookup", id="l")
    public void testIsUnsatisfied() {
        ObtainsInstanceBean injectionPoint = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]);
        assert (!injectionPoint.getAnyPaymentProcessor().isUnsatisfied());
        assert (injectionPoint.getPaymentProcessor().select(RemotePaymentProcessor.class, new Annotation[0]).isUnsatisfied());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="programmatic_lookup", id="da"), @SpecAssertion(section="dynamic_lookup", id="m")})
    public void testIsAmbiguous() {
        ObtainsInstanceBean injectionPoint = this.getContextualReference(ObtainsInstanceBean.class, new Annotation[0]);
        assert (injectionPoint.getAnyPaymentProcessor().isAmbiguous());
        assert (!injectionPoint.getPaymentProcessor().isAmbiguous());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="programmatic_lookup", id="e"), @SpecAssertion(section="annotationliteral_typeliteral", id="b")})
    public void testNewBean() {
        Instance<String> string = this.getContextualReference(ObtainsNewInstanceBean.class, new Annotation[0]).getString();
        assert (!string.isAmbiguous());
        assert (!string.isUnsatisfied());
        assert (string.get() != null);
        assert (string.get() instanceof String);
        Instance<Map<String, String>> map = this.getContextualReference(ObtainsNewInstanceBean.class, new Annotation[0]).getMap();
        assert (!map.isAmbiguous());
        assert (!map.isUnsatisfied());
        Map instance = (Map)map.get();
        assert (instance != null);
        assert (instance instanceof HashMap);
    }

    @Test
    @SpecAssertion(section="new", id="xc")
    public void testNewBeanNotEnabledWithouInjectionPoint() {
        assert (this.getContextualReference(ObtainsNewInstanceBean.class, new Annotation[0]).getIae().isUnsatisfied());
    }
}

