/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke;

import java.lang.annotation.Annotation;
import javax.transaction.UserTransaction;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke.BazInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke.Bean1;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke.Bean2;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke.Bean3;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke.Foo;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke.FooInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke.PrinterSecurityInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke.SimpleBean;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke.Student;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundInvoke.Toner;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="int", version="1.2")
public class AroundInvokeAccessInterceptorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AroundInvokeAccessInterceptorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="2.5", id="cb")
    public void testPrivateAroundInvokeInterceptor() {
        Assert.assertEquals((int)this.getContextualReference(SimpleBean.class, new Annotation[0]).zero(), (int)1);
        Assert.assertEquals((int)this.getContextualReference(Bean3.class, new Annotation[0]).zero(), (int)1);
    }

    @Test
    @SpecAssertion(section="2.5", id="cc")
    public void testProtectedAroundInvokeInterceptor() {
        Assert.assertEquals((int)this.getContextualReference(SimpleBean.class, new Annotation[0]).one(), (int)2);
        Assert.assertEquals((int)this.getContextualReference(Bean1.class, new Annotation[0]).zero(), (int)1);
    }

    @Test
    @SpecAssertion(section="2.5", id="cd")
    public void testPackagePrivateAroundInvokeInterceptor() {
        Assert.assertEquals((int)this.getContextualReference(SimpleBean.class, new Annotation[0]).two(), (int)3);
        Assert.assertEquals((int)this.getContextualReference(Bean2.class, new Annotation[0]).zero(), (int)1);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="2.5", id="e"), @SpecAssertion(section="2.5", id="fb")})
    public void testSecurityContext(Student student) throws Exception {
        student.printArticle();
        Assert.assertTrue((boolean)PrinterSecurityInterceptor.securityContextOK);
        Assert.assertTrue((boolean)Toner.calledFromInterceptor);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertion(section="2.5", id="fa")
    public void testTransactionContext(Foo foo, UserTransaction ut) throws Exception {
        ut.begin();
        foo.invoke();
        Assert.assertTrue((boolean)FooInterceptor.called);
        Assert.assertTrue((boolean)BazInterceptor.called);
        ut.commit();
    }
}

