/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb;

import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.Animal;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.environment.jndi.ejb.BarBinding;

@BarBinding
@Priority(value=1000)
@Interceptor
public class BarInterceptor {
    private static boolean interceptorCalled = false;
    private static String greeting;
    private static Animal animal;

    @Resource(name="greeting")
    private void setGreeting(String greeting) {
        BarInterceptor.greeting = greeting;
    }

    @Inject
    private void init() throws NamingException {
        animal = (Animal)InitialContext.doLookup("java:module/Animal");
    }

    public static void reset() {
        greeting = null;
        animal = null;
        interceptorCalled = false;
    }

    public static boolean isInterceptorCalled() {
        return interceptorCalled;
    }

    public static String getGreeting() {
        return greeting;
    }

    public static Animal getAnimal() {
        return animal;
    }

    @PostConstruct
    private void intercept(InvocationContext ctx) {
        interceptorCalled = true;
        try {
            ctx.proceed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

