/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.shrinkwrap.descriptors;

import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.cdi.tck.shrinkwrap.descriptors.Activator;
import org.jboss.cdi.tck.shrinkwrap.descriptors.Exclude;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExportException;
import org.jboss.shrinkwrap.descriptor.api.beans10.Alternatives;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.beans10.Decorators;
import org.jboss.shrinkwrap.descriptor.api.beans10.Interceptors;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Beans11DescriptorImpl
implements BeansDescriptor {
    private static final String NS = "http://xmlns.jcp.org/xml/ns/javaee";
    private BeanDiscoveryMode mode = BeanDiscoveryMode.ANNOTATED;
    private List<Class<?>> alternatives = new ArrayList(5);
    private List<Class<?>> interceptors = new ArrayList(5);
    private List<Class<?>> decorators = new ArrayList(5);
    private List<Class<?>> alternativeStereotypes = new ArrayList(5);
    private List<Exclude> excludes = new ArrayList<Exclude>(5);

    public Beans11DescriptorImpl setBeanDiscoveryMode(BeanDiscoveryMode mode) {
        this.mode = mode;
        return this;
    }

    public Beans11DescriptorImpl excludes(Exclude ... excludes) {
        this.excludes.addAll(Arrays.asList(excludes));
        return this;
    }

    public Beans11DescriptorImpl alternatives(Class<?> ... alternatives) {
        this.alternatives.addAll(Arrays.asList(alternatives));
        return this;
    }

    public Beans11DescriptorImpl alternativeStereotypes(Class<?> ... stereotypes) {
        this.alternativeStereotypes.addAll(Arrays.asList(stereotypes));
        return this;
    }

    public Beans11DescriptorImpl interceptors(Class<?> ... interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
        return this;
    }

    public Beans11DescriptorImpl decorators(Class<?> ... decorators) {
        this.decorators.addAll(Arrays.asList(decorators));
        return this;
    }

    public String getDescriptorName() {
        return "beans.xml";
    }

    public String exportAsString() throws DescriptorExportException {
        try {
            StringWriter writer = new StringWriter();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(this.buildDocument()), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot export beans.xml", e);
        }
    }

    private Document buildDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document doc = impl.createDocument(NS, "beans", null);
            Element rootElement = doc.getDocumentElement();
            rootElement.setAttribute("version", "1.1");
            rootElement.setAttribute("bean-discovery-mode", this.mode.toString().toLowerCase());
            if (!this.interceptors.isEmpty()) {
                Element interceptorsElement = doc.createElement("interceptors");
                rootElement.appendChild(interceptorsElement);
                for (Class<?> clazz : this.interceptors) {
                    this.appendChildTextElement(doc, interceptorsElement, "class", clazz.getName());
                }
            }
            if (!this.decorators.isEmpty()) {
                Element decoratorsElement = doc.createElement("decorators");
                rootElement.appendChild(decoratorsElement);
                for (Class<?> clazz : this.decorators) {
                    this.appendChildTextElement(doc, decoratorsElement, "class", clazz.getName());
                }
            }
            if (!this.alternatives.isEmpty() || !this.alternativeStereotypes.isEmpty()) {
                Element alternativesElement = doc.createElement("alternatives");
                rootElement.appendChild(alternativesElement);
                for (Class<?> clazz : this.alternatives) {
                    this.appendChildTextElement(doc, alternativesElement, "class", clazz.getName());
                }
                for (Class clazz : this.alternativeStereotypes) {
                    this.appendChildTextElement(doc, alternativesElement, "stereotype", clazz.getName());
                }
            }
            if (!this.excludes.isEmpty()) {
                Element scanElement = doc.createElement("scan");
                rootElement.appendChild(scanElement);
                for (Exclude exclude : this.excludes) {
                    Element exludeElement = doc.createElement("exclude");
                    exludeElement.setAttribute("name", exclude.getName());
                    if (!exclude.getActivators().isEmpty()) {
                        for (Activator activator : exclude.getActivators()) {
                            Element activatorElement = doc.createElement(activator.getElementName());
                            exludeElement.appendChild(activatorElement);
                            activatorElement.setAttribute("name", activator.getNameAttribute());
                            if (activator.getValueAttribute() == null) continue;
                            activatorElement.setAttribute("value", activator.getValueAttribute());
                        }
                    }
                    scanElement.appendChild(exludeElement);
                }
            }
            return doc;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot build beans.xml", e);
        }
    }

    private void appendChildTextElement(Document doc, Element element, String name, String text) {
        Element child = doc.createElement(name);
        child.appendChild(doc.createTextNode(text));
        element.appendChild(child);
    }

    public void exportTo(OutputStream output) throws DescriptorExportException, IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public BeansDescriptor addDefaultNamespaces() {
        throw new UnsupportedOperationException();
    }

    public BeansDescriptor addNamespace(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public List<String> getNamespaces() {
        throw new UnsupportedOperationException();
    }

    public BeansDescriptor removeAllNamespaces() {
        throw new UnsupportedOperationException();
    }

    public Interceptors<BeansDescriptor> getOrCreateInterceptors() {
        throw new UnsupportedOperationException();
    }

    public Interceptors<BeansDescriptor> createInterceptors() {
        throw new UnsupportedOperationException();
    }

    public List<Interceptors<BeansDescriptor>> getAllInterceptors() {
        throw new UnsupportedOperationException();
    }

    public BeansDescriptor removeAllInterceptors() {
        throw new UnsupportedOperationException();
    }

    public Decorators<BeansDescriptor> getOrCreateDecorators() {
        throw new UnsupportedOperationException();
    }

    public Decorators<BeansDescriptor> createDecorators() {
        throw new UnsupportedOperationException();
    }

    public List<Decorators<BeansDescriptor>> getAllDecorators() {
        throw new UnsupportedOperationException();
    }

    public BeansDescriptor removeAllDecorators() {
        throw new UnsupportedOperationException();
    }

    public Alternatives<BeansDescriptor> getOrCreateAlternatives() {
        throw new UnsupportedOperationException();
    }

    public Alternatives<BeansDescriptor> createAlternatives() {
        throw new UnsupportedOperationException();
    }

    public List<Alternatives<BeansDescriptor>> getAllAlternatives() {
        throw new UnsupportedOperationException();
    }

    public BeansDescriptor removeAllAlternatives() {
        throw new UnsupportedOperationException();
    }

    public static Beans11DescriptorImpl newBeans11Descriptor() {
        return new Beans11DescriptorImpl();
    }

    public static enum BeanDiscoveryMode {
        ANNOTATED,
        ALL,
        NONE;

    }
}

