/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.non.contextual;

import java.util.EventListener;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.Farm;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.SessionBean;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.Sheep;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TagLibraryListener;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestFilter;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestListener;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestServlet;
import org.jboss.cdi.tck.tests.lookup.injection.non.contextual.TestTagHandler;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class ContainerEventTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ContainerEventTest.class)).withWebXml("web.xml")).withClasses(Farm.class, ProcessAnnotatedTypeObserver.class, Sheep.class, TagLibraryListener.class, TestFilter.class, TestListener.class, TestServlet.class, TestTagHandler.class, SessionBean.class)).withExtension(ProcessAnnotatedTypeObserver.class)).withWebResource("ManagedBeanTestPage.jsp", "ManagedBeanTestPage.jsp")).withWebResource("TagPage.jsp", "TagPage.jsp")).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withWebResource("TestLibrary.tld", "WEB-INF/TestLibrary.tld")).withDefaultPersistenceXml()).build();
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="bean_discovery", id="be")
    public void testProcessAnnotatedTypeEventFiredForServletListener() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getListenerEvent());
        this.validateServletListenerAnnotatedType((AnnotatedType<TestListener>)ProcessAnnotatedTypeObserver.getListenerEvent().getAnnotatedType());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="bean_discovery", id="bf")
    public void testProcessAnnotatedTypeEventFiredForTagHandler() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getTagHandlerEvent());
        this.validateTagHandlerAnnotatedType((AnnotatedType<TestTagHandler>)ProcessAnnotatedTypeObserver.getTagHandlerEvent().getAnnotatedType());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="bean_discovery", id="bg")
    public void testProcessAnnotatedTypeEventFiredForTagLibraryListener() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getTagLibraryListenerEvent());
        this.validateTagLibraryListenerAnnotatedType((AnnotatedType<TagLibraryListener>)ProcessAnnotatedTypeObserver.getTagLibraryListenerEvent().getAnnotatedType());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="bean_discovery", id="bj")
    public void testProcessAnnotatedTypeEventFiredForServlet() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getServletEvent());
        this.validateServletAnnotatedType((AnnotatedType<TestServlet>)ProcessAnnotatedTypeObserver.getServletEvent().getAnnotatedType());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="bean_discovery", id="bk")
    public void testProcessAnnotatedTypeEventFiredForFilter() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getFilterEvent());
        this.validateFilterAnnotatedType((AnnotatedType<TestFilter>)ProcessAnnotatedTypeObserver.getFilterEvent().getAnnotatedType());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="bean_discovery", id="bd")
    public void testProcessAnnotatedTypeEventFiredForJsfManagedBean() {
        Assert.assertNotNull(ProcessAnnotatedTypeObserver.getJsfManagedBeanEvent());
        this.validateJsfManagedBeanAnnotatedType((AnnotatedType<Farm>)ProcessAnnotatedTypeObserver.getJsfManagedBeanEvent().getAnnotatedType());
    }

    private void validateServletListenerAnnotatedType(AnnotatedType<TestListener> type) {
        Assert.assertEquals((Object)type.getBaseType(), TestListener.class);
        Assert.assertTrue((boolean)type.getAnnotations().isEmpty());
        Assert.assertEquals((int)type.getFields().size(), (int)2);
        Assert.assertEquals((int)type.getMethods().size(), (int)3);
        int initializers = 0;
        for (AnnotatedMethod method : type.getMethods()) {
            Assert.assertEquals((int)method.getParameters().size(), (int)1);
            Assert.assertEquals((Object)method.getBaseType(), Void.TYPE);
            if (!method.isAnnotationPresent(Inject.class)) continue;
            ++initializers;
        }
        Assert.assertEquals((int)initializers, (int)1);
    }

    private void validateTagHandlerAnnotatedType(AnnotatedType<TestTagHandler> type) {
        Assert.assertEquals((Object)type.getBaseType(), TestTagHandler.class);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(type.getTypeClosure(), TestTagHandler.class, SimpleTagSupport.class, SimpleTag.class, JspTag.class));
        Assert.assertEquals((int)type.getAnnotations().size(), (int)1);
        Assert.assertTrue((boolean)type.isAnnotationPresent(Any.class));
    }

    private void validateTagLibraryListenerAnnotatedType(AnnotatedType<TagLibraryListener> type) {
        Assert.assertEquals((Object)type.getBaseType(), TagLibraryListener.class);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(type.getTypeClosure(), TagLibraryListener.class, ServletContextListener.class, EventListener.class, Object.class));
        Assert.assertEquals((int)type.getFields().size(), (int)2);
        Assert.assertEquals((int)type.getConstructors().size(), (int)1);
        Assert.assertEquals((int)type.getMethods().size(), (int)3);
    }

    private void validateServletAnnotatedType(AnnotatedType<TestServlet> type) {
        Assert.assertEquals((Object)type.getBaseType(), TestServlet.class);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(type.getTypeClosure(), TestServlet.class, HttpServlet.class, GenericServlet.class, Servlet.class, ServletConfig.class, Object.class));
        Assert.assertTrue((boolean)type.getAnnotations().isEmpty());
    }

    private void validateFilterAnnotatedType(AnnotatedType<TestFilter> type) {
        Assert.assertEquals((Object)type.getBaseType(), TestFilter.class);
        Assert.assertTrue((boolean)this.rawTypeSetMatches(type.getTypeClosure(), TestFilter.class, Filter.class, Object.class));
        Assert.assertEquals((int)type.getFields().size(), (int)12);
        Assert.assertEquals((int)type.getConstructors().size(), (int)1);
        Assert.assertTrue((boolean)((AnnotatedConstructor)type.getConstructors().iterator().next()).getParameters().isEmpty());
        Assert.assertEquals((int)type.getMethods().size(), (int)8);
    }

    private void validateJsfManagedBeanAnnotatedType(AnnotatedType<Farm> type) {
        assert (type.getFields().size() == 2);
        for (AnnotatedField field : type.getFields()) {
            if (field.getJavaMember().getName().equals("sheep")) {
                Assert.assertTrue((boolean)field.isAnnotationPresent(Inject.class));
                Assert.assertFalse((boolean)field.isStatic());
                continue;
            }
            if (field.getJavaMember().getName().equals("initializerCalled")) {
                Assert.assertFalse((boolean)field.isStatic());
                Assert.assertTrue((boolean)field.getBaseType().equals(Boolean.TYPE));
                continue;
            }
            Assert.fail();
        }
        Assert.assertEquals((int)type.getMethods().size(), (int)3);
    }
}

