/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.invocationContext;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.invocationContext.Interceptor1;
import org.jboss.cdi.tck.interceptors.tests.contract.invocationContext.Interceptor7;
import org.jboss.cdi.tck.interceptors.tests.contract.invocationContext.Interceptor8;
import org.jboss.cdi.tck.interceptors.tests.contract.invocationContext.Interceptor9;
import org.jboss.cdi.tck.interceptors.tests.contract.invocationContext.PostConstructInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.invocationContext.SimpleBean;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="int", version="1.2")
public class InvocationContextTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InvocationContextTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.8", id="aa"), @SpecAssertion(section="2.3", id="c")})
    public void testGetTargetMethod() {
        SimpleBean instance = this.getContextualReference(SimpleBean.class, new Annotation[0]);
        instance.setId(10);
        Assert.assertEquals((int)instance.getId(), (int)10);
        Assert.assertTrue((boolean)Interceptor1.isGetTargetOK());
    }

    @Test
    @SpecAssertion(section="2.3", id="db")
    public void testGetTimerMethod() {
        Assert.assertTrue((boolean)this.getContextualReference(SimpleBean.class, new Annotation[0]).testGetTimer());
    }

    @Test
    @SpecAssertion(section="2.3", id="ea")
    public void testGetMethodForAroundInvokeInterceptorMethod() {
        Assert.assertTrue((boolean)this.getContextualReference(SimpleBean.class, new Annotation[0]).testGetMethod());
    }

    @Test
    @SpecAssertion(section="2.3", id="eb")
    public void testGetMethodForLifecycleCallbackInterceptorMethod() {
        this.getContextualReference(SimpleBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)PostConstructInterceptor.isGetMethodReturnsNull());
    }

    @Test
    @SpecAssertion(section="2.3", id="l")
    public void testCtxProceedForLifecycleCallbackInterceptorMethod() {
        this.getContextualReference(SimpleBean.class, new Annotation[0]);
        Assert.assertTrue((boolean)PostConstructInterceptor.isCtxProceedReturnsNull());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.3", id="f"), @SpecAssertion(section="2.3", id="ga")})
    public void testMethodParameters() {
        Assert.assertEquals((int)this.getContextualReference(SimpleBean.class, new Annotation[0]).add(1, 2), (int)5);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="2.3", id="gb")
    public void testIllegalNumberOfParameters() {
        this.getContextualReference(SimpleBean.class, new Annotation[0]).add2(1, 1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="2.3", id="gc")
    public void testIllegalTypeOfParameters() {
        this.getContextualReference(SimpleBean.class, new Annotation[0]).add3(1, 1);
    }

    @Test
    @SpecAssertion(section="2.3", id="k")
    public void testProceedReturnsNullForVoidMethod() {
        this.getContextualReference(SimpleBean.class, new Annotation[0]).voidMethod();
        Assert.assertTrue((boolean)Interceptor7.isProceedReturnsNull());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="2.3", id="ba")})
    public void testContextData() {
        this.getContextualReference(SimpleBean.class, new Annotation[0]).foo();
        Assert.assertTrue((boolean)Interceptor8.isContextDataOK());
        Assert.assertTrue((boolean)Interceptor9.isContextDataOK());
    }

    @Test
    @SpecAssertion(section="2.3", id="j")
    public void testBusinessMethodNotCalledWithoutProceedInvocation() {
        assert (this.getContextualReference(SimpleBean.class, new Annotation[0]).echo("foo").equals("foo"));
        assert (!SimpleBean.isEchoCalled());
    }
}

