/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.atd;

import java.lang.annotation.Annotation;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.AfterTypeDiscoveryObserver;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.AlphaAlternative;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.AlphaDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.AlphaInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.BravoAlternative;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.BravoDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.BravoInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.CharlieAlternative;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.CharlieDecorator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.CharlieInterceptor;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.TransactionLogger;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Bar;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Boss;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Foo;
import org.jboss.cdi.tck.tests.extensions.lifecycle.atd.lib.Pro;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="1.1 Final Release")
public class AfterTypeDiscoveryTest
extends AbstractTest {
    @Inject
    AfterTypeDiscoveryObserver extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AfterTypeDiscoveryTest.class)).withExtension(AfterTypeDiscoveryObserver.class)).withLibrary(Boss.class, Foo.class, Bar.class, Pro.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{CharlieInterceptor.class.getName()}).up()).createDecorators().clazz(new String[]{CharlieDecorator.class.getName()}).up()).createAlternatives().clazz(new String[]{CharlieAlternative.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="atd", id="a"), @SpecAssertion(section="atd", id="c"), @SpecAssertion(section="atd", id="hb")})
    public void testInitialInterceptors() {
        Assert.assertTrue((boolean)this.extension.getInterceptors().contains(BravoInterceptor.class));
        Assert.assertTrue((boolean)this.extension.getInterceptors().contains(AlphaInterceptor.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="atd", id="b"), @SpecAssertion(section="atd", id="ha")})
    public void testInitialAlternatives() {
        Assert.assertEquals((int)this.extension.getAlternatives().size(), (int)2);
        Assert.assertEquals(this.extension.getAlternatives().get(0), AlphaAlternative.class);
        Assert.assertEquals(this.extension.getAlternatives().get(1), BravoAlternative.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="atd", id="d"), @SpecAssertion(section="atd", id="hc")})
    public void testInitialDecorators() {
        Assert.assertEquals((int)this.extension.getDecorators().size(), (int)2);
        Assert.assertEquals(this.extension.getDecorators().get(0), AlphaDecorator.class);
        Assert.assertEquals(this.extension.getDecorators().get(1), BravoDecorator.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="atd", id="gb")})
    public void testFinalInterceptors(TransactionLogger logger) {
        AlphaInterceptor.reset();
        BravoInterceptor.reset();
        CharlieInterceptor.reset();
        logger.ping();
        Assert.assertTrue((boolean)AlphaInterceptor.isIntercepted());
        Assert.assertFalse((boolean)BravoInterceptor.isIntercepted());
        Assert.assertTrue((boolean)CharlieInterceptor.isIntercepted());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="atd", id="gc")})
    public void testFinalDecorators(TransactionLogger logger) {
        Assert.assertEquals((String)logger.log("ping"), (String)"pingbravoalphacharlie");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="atd", id="ga")})
    public void testFinalAlternatives() {
        Assert.assertTrue((boolean)this.getBeans(AlphaAlternative.class, new Annotation[0]).isEmpty());
        Assert.assertTrue((boolean)this.getBeans(BravoAlternative.class, new Annotation[0]).isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="atd", id="e"), @SpecAssertion(section="bean_discovery", id="r")})
    public void testAddAnnotatedType() {
        Assert.assertTrue((boolean)this.extension.isBossObserved());
        this.getUniqueBean(Boss.class, new Annotation[0]);
        Assert.assertEquals((int)this.getBeans(Bar.class, new Annotation[0]).size(), (int)0);
        Assert.assertEquals((int)this.getBeans(Bar.class, new Annotation[]{new AnnotationLiteral<Pro>(){}}).size(), (int)1);
        Assert.assertEquals((int)this.getBeans(Foo.class, new Annotation[0]).size(), (int)0);
        Assert.assertEquals((int)this.getBeans(Foo.class, new Annotation[]{new AnnotationLiteral<Pro>(){}}).size(), (int)1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pp", id="ab"), @SpecAssertion(section="pp", id="bb")})
    public void testProcessProducerEventFiredForProducerField() {
        Assert.assertTrue((boolean)this.extension.isProcessProcuderFieldObserved());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="pp", id="aa"), @SpecAssertion(section="pp", id="ba")})
    public void testProcessProducerEventFiredForProducerMethod() {
        Assert.assertTrue((boolean)this.extension.isProcessProcuderMethodObserved());
    }
}

