/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.enterprise.order;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.enterprise.order.AnotherInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.enterprise.order.Missile;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.enterprise.order.MissileInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.lifecycle.enterprise.order.Weapon;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class EnterpriseLifecycleInterceptorDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseLifecycleInterceptorDefinitionTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{MissileInterceptor.class.getName()}).up())).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="enabled_interceptors", id="g"), @SpecAssertion(section="enabled_interceptors", id="h")})
    public void testLifecycleInterception() {
        ActionSequence.reset();
        Bean<Missile> bean = this.getUniqueBean(Missile.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Missile missile = (Missile)bean.create(ctx);
        missile.fire();
        bean.destroy((Object)missile, ctx);
        List<String> postConstruct = ActionSequence.getSequenceData("postConstruct");
        Assert.assertEquals((int)postConstruct.size(), (int)4);
        Assert.assertEquals((String)postConstruct.get(0), (String)AnotherInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(1), (String)MissileInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(2), (String)Weapon.class.getName());
        Assert.assertEquals((String)postConstruct.get(3), (String)Missile.class.getName());
        List<String> preDestroy = ActionSequence.getSequenceData("preDestroy");
        Assert.assertEquals((int)preDestroy.size(), (int)4);
        Assert.assertEquals((String)postConstruct.get(0), (String)AnotherInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(1), (String)MissileInterceptor.class.getName());
        Assert.assertEquals((String)postConstruct.get(2), (String)Weapon.class.getName());
        Assert.assertEquals((String)postConstruct.get(3), (String)Missile.class.getName());
    }
}

