/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.aroundTimeout;

import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundTimeout.Alarm;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundTimeout.AlarmSecurityInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundTimeout.Bell;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundTimeout.Student;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundTimeout.TimeoutInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.aroundTimeout.TimingBean;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="int", version="1.2")
public class AroundTimeoutInterceptorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AroundTimeoutInterceptorTest.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="2.7", id="f"), @SpecAssertion(section="2.7", id="ea")})
    public void testInvocationContextGetTimer(TimingBean timingBean) throws Exception {
        timingBean.createTimer();
        new Timer().setDelay(5L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return TimingBean.timeoutAt != null;
            }
        }).start();
        Assert.assertNotNull((Object)TimingBean.timeoutAt);
        AssertJUnit.assertTrue((boolean)TimeoutInterceptor.timerOK);
        Assert.assertEquals((Object)TimeoutInterceptor.key, (Object)TimingBean.key, (String)"Around-timeout method invocation did NOT occur within the same transaction context as the timeout method on which it is interposing");
    }

    @Test(enabled=false, dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="2.7", id="d"), @SpecAssertion(section="2.7", id="eb")})
    public void testSecurityContext(Student student) throws Exception {
        student.sleep();
        new Timer().setDelay(5L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return Alarm.timeoutAt != null;
            }
        }).start();
        Assert.assertNotNull((Object)Alarm.timeoutAt);
        AssertJUnit.assertTrue((boolean)AlarmSecurityInterceptor.securityContextOK);
        AssertJUnit.assertTrue((boolean)Bell.calledFromInterceptor);
    }
}

