/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.scope;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.scope.AnotherScopeType;
import org.jboss.cdi.tck.tests.definition.scope.BorderCollie;
import org.jboss.cdi.tck.tests.definition.scope.EnglishBorderCollie;
import org.jboss.cdi.tck.tests.definition.scope.GoldenLabrador;
import org.jboss.cdi.tck.tests.definition.scope.GoldenRetriever;
import org.jboss.cdi.tck.tests.definition.scope.Grayling;
import org.jboss.cdi.tck.tests.definition.scope.MiniatureClydesdale;
import org.jboss.cdi.tck.tests.definition.scope.Minnow;
import org.jboss.cdi.tck.tests.definition.scope.Mullet;
import org.jboss.cdi.tck.tests.definition.scope.Order;
import org.jboss.cdi.tck.tests.definition.scope.Pollock;
import org.jboss.cdi.tck.tests.definition.scope.RedSnapper;
import org.jboss.cdi.tck.tests.definition.scope.SeaBass;
import org.jboss.cdi.tck.tests.definition.scope.ShetlandPony;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class ScopeDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ScopeDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="scopes", id="c")
    public void testScopeTypesAreExtensible() {
        assert (this.getBeans(Mullet.class, new Annotation[0]).size() == 1);
        Bean<Mullet> bean = this.getBeans(Mullet.class, new Annotation[0]).iterator().next();
        assert (bean.getScope().equals(AnotherScopeType.class));
    }

    @Test
    @SpecAssertion(section="defining_new_scope_type", id="aa")
    public void testScopeTypeHasCorrectTarget() {
        assert (this.getBeans(Mullet.class, new Annotation[0]).size() == 1);
        Bean<Mullet> bean = this.getBeans(Mullet.class, new Annotation[0]).iterator().next();
        Target target = bean.getScope().getAnnotation(Target.class);
        List<ElementType> elements = Arrays.asList(target.value());
        assert (elements.contains((Object)ElementType.TYPE));
        assert (elements.contains((Object)ElementType.METHOD));
        assert (elements.contains((Object)ElementType.FIELD));
    }

    @Test
    @SpecAssertion(section="defining_new_scope_type", id="ba")
    public void testScopeTypeDeclaresScopeTypeAnnotation() {
        assert (this.getBeans(Mullet.class, new Annotation[0]).size() == 1);
        Bean<Mullet> bean = this.getBeans(Mullet.class, new Annotation[0]).iterator().next();
        assert (bean.getScope().getAnnotation(NormalScope.class) != null);
    }

    @Test
    @SpecAssertion(section="declaring_bean_scope", id="a")
    public void testScopeDeclaredInJava() {
        assert (this.getBeans(SeaBass.class, new Annotation[0]).size() == 1);
        Bean<SeaBass> bean = this.getBeans(SeaBass.class, new Annotation[0]).iterator().next();
        assert (bean.getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section="default_scope", id="aa")
    public void testDefaultScope() {
        assert (this.getBeans(Order.class, new Annotation[0]).size() == 1);
        Bean<Order> bean = this.getBeans(Order.class, new Annotation[0]).iterator().next();
        assert (bean.getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="default_scope", id="e"), @SpecAssertion(section="declaring_stereotypes", id="a")})
    public void testScopeSpecifiedAndStereotyped() {
        assert (this.getBeans(Minnow.class, new Annotation[0]).size() == 1);
        Bean<Minnow> bean = this.getBeans(Minnow.class, new Annotation[0]).iterator().next();
        assert (bean.getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section="default_scope", id="da")
    public void testMultipleIncompatibleScopeStereotypesWithScopeSpecified() {
        assert (this.getBeans(Pollock.class, new Annotation[0]).size() == 1);
        Bean<Pollock> bean = this.getBeans(Pollock.class, new Annotation[0]).iterator().next();
        assert (bean.getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section="default_scope", id="c")
    public void testMultipleCompatibleScopeStereotypes() {
        assert (this.getBeans(Grayling.class, new Annotation[0]).size() == 1);
        Bean<Grayling> bean = this.getBeans(Grayling.class, new Annotation[0]).iterator().next();
        assert (bean.getScope().equals(ApplicationScoped.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_stereotypes", id="db"), @SpecAssertion(section="type_level_inheritance", id="ab")})
    public void testWebBeanScopeTypeOverridesStereotype() {
        assert (this.getBeans(RedSnapper.class, new Annotation[0]).size() == 1);
        Bean<RedSnapper> bean = this.getBeans(RedSnapper.class, new Annotation[0]).iterator().next();
        assert (bean.getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="ba")
    public void testScopeTypeDeclaredInheritedIsInherited() throws Exception {
        assert (this.getBeans(BorderCollie.class, new Annotation[0]).iterator().next().getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="baa")
    public void testScopeTypeNotDeclaredInheritedIsNotInherited() {
        assert (this.getBeans(ShetlandPony.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(ShetlandPony.class, new Annotation[0]).iterator().next().getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="ba")
    public void testScopeTypeDeclaredInheritedIsBlockedByIntermediateScopeTypeMarkedInherited() {
        assert (this.getBeans(GoldenRetriever.class, new Annotation[0]).size() == 1);
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="ba")
    public void testScopeTypeDeclaredInheritedIsBlockedByIntermediateScopeTypeNotMarkedInherited() {
        assert (this.getBeans(GoldenLabrador.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(GoldenLabrador.class, new Annotation[0]).iterator().next().getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="bc")
    public void testScopeTypeDeclaredInheritedIsIndirectlyInherited() {
        assert (this.getBeans(EnglishBorderCollie.class, new Annotation[0]).iterator().next().getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="bca")
    public void testScopeTypeNotDeclaredInheritedIsNotIndirectlyInherited() {
        assert (this.getBeans(MiniatureClydesdale.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(MiniatureClydesdale.class, new Annotation[0]).iterator().next().getScope().equals(Dependent.class));
    }
}

