/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.transactional;

import java.util.List;
import javax.enterprise.event.TransactionPhase;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.transactional.AccountService;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.cdi.tck.util.SimpleLogger;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration", "persistence"})
@SpecVersion(spec="cdi", version="1.1 Final Release")
public class TransactionalObserverTest
extends AbstractTest {
    private static final SimpleLogger logger = new SimpleLogger(TransactionalObserverTest.class);
    @Inject
    AccountService accountService;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(TransactionalObserverTest.class)).withDefaultPersistenceXml()).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="transactional_observer_methods", id="a"), @SpecAssertion(section="transactional_observer_methods", id="b"), @SpecAssertion(section="transactional_observer_methods", id="c"), @SpecAssertion(section="transactional_observer_methods", id="d"), @SpecAssertion(section="transactional_observer_methods", id="e"), @SpecAssertion(section="transactional_observer_methods", id="gaa"), @SpecAssertion(section="observer_notification", id="bb")})
    public void testSucessfullTransaction() throws Exception {
        logger.log("testSucessfullTransaction", new Object[0]);
        ActionSequence.reset();
        this.accountService.withdrawSuccesTransaction(1);
        ActionSequence.getSequence().beginsWith(TransactionPhase.IN_PROGRESS.toString(), "checkpoint", TransactionPhase.BEFORE_COMPLETION.toString());
        ActionSequence.getSequence().containsAll(TransactionPhase.AFTER_SUCCESS.toString(), TransactionPhase.AFTER_COMPLETION.toString());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="transactional_observer_methods", id="a"), @SpecAssertion(section="transactional_observer_methods", id="b"), @SpecAssertion(section="transactional_observer_methods", id="c"), @SpecAssertion(section="transactional_observer_methods", id="d"), @SpecAssertion(section="transactional_observer_methods", id="e"), @SpecAssertion(section="transactional_observer_methods", id="gaa"), @SpecAssertion(section="observer_notification", id="bb")})
    public void testFailedTransaction() throws Exception {
        logger.log("testFailedTransaction", new Object[0]);
        ActionSequence.reset();
        this.accountService.withdrawFailedTransaction(2);
        ActionSequence.getSequence().beginsWith(TransactionPhase.IN_PROGRESS.toString(), "checkpoint");
        ActionSequence.getSequence().containsAll(TransactionPhase.AFTER_FAILURE.toString(), TransactionPhase.AFTER_COMPLETION.toString());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="transactional_observer_methods", id="a"), @SpecAssertion(section="observer_notification", id="bc")})
    public void testNoTransaction() throws Exception {
        logger.log("testNoTransaction", new Object[0]);
        ActionSequence.reset();
        this.accountService.withdrawNoTransaction(3);
        List<String> sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)sequence.size(), (int)6);
        Assert.assertEquals((String)sequence.get(sequence.size() - 1), (String)"checkpoint");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_notification", id="bda")})
    public void testObserverFailedTransaction() throws Exception {
        logger.log("testObserverFailedTransaction", new Object[0]);
        ActionSequence.reset();
        this.accountService.withdrawObserverFailedTransaction(2);
        ActionSequence.getSequence().beginsWith(TransactionPhase.IN_PROGRESS.toString(), TransactionPhase.IN_PROGRESS.toString(), "checkpoint");
        ActionSequence.getSequence().containsAll(TransactionPhase.AFTER_FAILURE.toString(), TransactionPhase.AFTER_COMPLETION.toString());
    }
}

