/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.passivating;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.passivating.City;
import org.jboss.cdi.tck.tests.context.passivating.HelsinkiNonSerializable;
import org.jboss.cdi.tck.tests.context.passivating.Joensuu;
import org.jboss.cdi.tck.tests.context.passivating.Jyvaskyla;
import org.jboss.cdi.tck.tests.context.passivating.Kajaani;
import org.jboss.cdi.tck.tests.context.passivating.Kokkola;
import org.jboss.cdi.tck.tests.context.passivating.NumberConsumer;
import org.jboss.cdi.tck.tests.context.passivating.Record;
import org.jboss.cdi.tck.tests.context.passivating.SerializableCityConsumer;
import org.jboss.cdi.tck.tests.context.passivating.Television;
import org.jboss.cdi.tck.tests.context.passivating.Wheat;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class PassivatingContextTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(PassivatingContextTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable", id="ba"), @SpecAssertion(section="passivating_scopes", id="a")})
    public void testManagedBeanWithSerializableImplementationClassOK() {
        Set<Bean<Jyvaskyla>> beans = this.getBeans(Jyvaskyla.class, new Annotation[0]);
        Assert.assertFalse((boolean)beans.isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable", id="bb"), @SpecAssertion(section="passivating_scope", id="a")})
    public void testManagedBeanWithSerializableInterceptorClassOK() throws ClassNotFoundException, IOException {
        Set<Bean<Kokkola>> beans = this.getBeans(Kokkola.class, new Annotation[0]);
        Assert.assertFalse((boolean)beans.isEmpty());
        Bean<Kokkola> bean = beans.iterator().next();
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Kokkola instance = (Kokkola)this.getCurrentManager().getReference(bean, Kokkola.class, ctx);
        Assert.assertEquals((int)instance.ping(), (int)1);
        Kokkola instance2 = (Kokkola)this.activate(this.passivate(instance));
        Assert.assertEquals((int)instance2.ping(), (int)2);
    }

    @Test
    @SpecAssertion(section="passivation_capable", id="bc")
    public void testManagedBeanWithSerializableDecoratorOK() {
        Set<Bean<City>> beans = this.getBeans(City.class, new Annotation[0]);
        Assert.assertFalse((boolean)beans.isEmpty());
    }

    @Test
    @SpecAssertion(section="passivation_capable", id="ca")
    public void testPassivationCapableProducerMethodIsOK() {
        Set<Bean<Record>> beans = this.getBeans(Record.class, new Annotation[0]);
        Assert.assertFalse((boolean)beans.isEmpty());
    }

    @Test
    @SpecAssertion(section="passivation_capable", id="da")
    public void testPassivationCapableProducerFieldIsOK() {
        Set<Bean<Wheat>> beans = this.getBeans(Wheat.class, new Annotation[0]);
        Assert.assertFalse((boolean)beans.isEmpty());
    }

    @Test
    @SpecAssertion(section="passivation_capable_dependency", id="c")
    public void testInjectionOfDependentPrimitiveProductIntoNormalBean() {
        this.getContextualReference(NumberConsumer.class, new Annotation[0]).ping();
    }

    @Test
    @SpecAssertion(section="passivation_capable_dependency", id="c")
    public void testInjectionOfDependentSerializableProductIntoNormalBean() {
        this.getContextualReference(SerializableCityConsumer.class, new Annotation[0]).ping();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="passivating_scope", id="a")})
    public void testPassivationOccurs() throws IOException, ClassNotFoundException {
        Kajaani instance = this.getContextualReference(Kajaani.class, new Annotation[0]);
        instance.setTheNumber(100);
        Context sessionContext = this.getCurrentManager().getContext(SessionScoped.class);
        this.setContextInactive(sessionContext);
        this.setContextActive(sessionContext);
        instance = this.getContextualReference(Kajaani.class, new Annotation[0]);
        Assert.assertEquals((int)instance.getTheNumber(), (int)100);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="passivation_validation", id="ab"), @SpecAssertion(section="passivation_capable_injection_points", id="a")})
    public void testBeanWithNonSerializableImplementationInjectedIntoTransientFieldOK() {
        Set<Bean<Joensuu>> beans = this.getBeans(Joensuu.class, new Annotation[0]);
        Assert.assertFalse((boolean)beans.isEmpty());
    }

    @Test(expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section="passivation_validation", id="ea")
    public void testPassivatingScopeProducerMethodReturnsUnserializableObjectNotOk() {
        this.getContextualReference(Television.class, new Annotation[0]).turnOn();
    }

    @Test(expectedExceptions={IllegalProductException.class})
    @SpecAssertion(section="passivation_validation", id="eb")
    public void testNonSerializableProducerFieldDeclaredPassivatingThrowsIllegalProductException() {
        this.getContextualReference(HelsinkiNonSerializable.class, new Annotation[0]).ping();
    }
}

