/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.Animal;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.Cat;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.Cute;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.ModifyingExtension;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.PersianStereotype;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.modify.Wild;
import org.jboss.cdi.tck.util.Assert;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class SetBeanAttributesTest
extends AbstractTest {
    @Inject
    ModifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SetBeanAttributesTest.class)).withExtension(ModifyingExtension.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createAlternatives().clazz(new String[]{Cat.class.getName()}).up())).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="pba", id="bc"), @SpecAssertion(section="pba", id="ca")})
    public void testBeanModified() {
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Cat.class, new Annotation[]{DefaultLiteral.INSTANCE}).size(), (int)0);
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Animal.class, new Annotation[]{AnyLiteral.INSTANCE}).size(), (int)0);
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Animal.class, new Annotation[]{new Wild.Literal(false)}).size(), (int)0);
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Cat.class, new Annotation[]{new Wild.Literal(true)}).size(), (int)1);
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans(Cat.class, new Annotation[]{new Cute.Literal()}).size(), (int)1);
        org.testng.Assert.assertEquals((int)this.getCurrentManager().getBeans("cat").size(), (int)1);
        Bean<Cat> bean = this.getUniqueBean(Cat.class, new Cute.Literal());
        Assert.assertTypeSetMatches(bean.getTypes(), new Type[]{Object.class, Cat.class});
        Assert.assertTypeSetMatches(bean.getStereotypes(), new Type[]{PersianStereotype.class});
        org.testng.Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)bean.getQualifiers(), new Annotation[]{new Wild.Literal(true), new Cute.Literal(), AnyLiteral.INSTANCE}));
        org.testng.Assert.assertEquals(ApplicationScoped.class, (Object)bean.getScope());
        org.testng.Assert.assertEquals((boolean)true, (boolean)bean.isAlternative());
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="pba", id="cc")})
    public void testChangesAreNotPropagated() {
        org.testng.Assert.assertTrue((boolean)this.extension.getCatAnnotatedType().getAnnotations().isEmpty());
        Assert.assertTypeSetMatches(this.extension.getCatAnnotatedType().getTypeClosure(), new Type[]{Object.class, Cat.class, Animal.class});
    }
}

