/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.enterprise.context.Conversation;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.cdi.tck.tests.context.conversation.servlet.Message;

@WebServlet(value={"/servlet/*"})
public class Servlet
extends HttpServlet {
    @Inject
    private Message message;
    @Inject
    private Conversation conversation;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getRequestURI();
        if (uri.endsWith("/display")) {
            this.printInfo(resp.getWriter());
        } else if (uri.endsWith("/begin")) {
            this.conversation.begin();
            this.printInfo(resp.getWriter());
        } else if (uri.endsWith("/end")) {
            this.conversation.end();
            this.printInfo(resp.getWriter());
        } else if (uri.endsWith("/set")) {
            this.setMessage(req);
            this.printInfo(resp.getWriter());
        } else if (uri.endsWith("/invalidateSession")) {
            req.getSession().invalidate();
            this.printInfo(resp.getWriter());
        } else {
            resp.setStatus(404);
        }
        resp.setContentType("text/plain");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getRequestURI();
        if (uri.endsWith("/set")) {
            this.setMessage(req);
            this.printInfo(resp.getWriter());
        } else {
            resp.setStatus(404);
        }
        resp.setContentType("text/plain");
    }

    private void printInfo(PrintWriter writer) {
        writer.append("message: " + this.message.getValue());
        writer.append("\n");
        writer.append("cid: [" + this.conversation.getId());
        writer.append("]");
        writer.append("\n");
        writer.append("transient: " + this.conversation.isTransient());
    }

    private void setMessage(HttpServletRequest request) {
        String value = request.getParameter("message");
        if (value == null) {
            throw new IllegalArgumentException("message must be specified");
        }
        this.message.setValue(value);
    }
}

