/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.event.jms;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.descriptors.ejb.EjbJarDescriptorBuilder;
import org.jboss.cdi.tck.tests.context.request.event.jms.AbstractMessageListener;
import org.jboss.cdi.tck.tests.context.request.event.jms.ApplicationScopedObserver;
import org.jboss.cdi.tck.tests.context.request.event.jms.SimpleMessageProducer;
import org.jboss.cdi.tck.tests.context.request.event.jms.TopicMessageDrivenBean;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.ejbjar31.EjbJarDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class RequestScopeEventMessageDeliveryTest
extends AbstractTest {
    @Inject
    private SimpleMessageProducer producer;
    @Inject
    private ApplicationScopedObserver observer;

    @Deployment
    public static WebArchive createTestArchive() {
        EjbJarDescriptor ejbJarDescriptor = new EjbJarDescriptorBuilder().messageDrivenBeans(EjbJarDescriptorBuilder.MessageDriven.newMessageDriven("TestTopic", TopicMessageDrivenBean.class.getName()).addActivationConfigProperty("acknowledgeMode", "Auto-acknowledge").addActivationConfigProperty("destinationType", "javax.jms.Topic").addActivationConfigProperty("destinationLookup", ConfigurationFactory.get().getTestJmsTopic())).build();
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestScopeEventMessageDeliveryTest.class)).withEjbJarXml(ejbJarDescriptor)).build();
    }

    @Test(groups={"javaee-full", "jms"})
    @SpecAssertions(value={@SpecAssertion(section="request_context", id="jf")})
    public void testEventsFired() throws Exception {
        new Timer().setDelay(5L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return AbstractMessageListener.isInitialized();
            }
        }).start();
        AbstractMessageListener.reset();
        this.observer.reset();
        this.producer.sendTopicMessage();
        new Timer().setDelay(5L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return AbstractMessageListener.isInitializedEventObserver() && AbstractMessageListener.getProcessedMessages() >= 1;
            }
        }).start();
        Assert.assertEquals((int)1, (int)AbstractMessageListener.getProcessedMessages());
        Assert.assertTrue((boolean)AbstractMessageListener.isInitializedEventObserver());
        new Timer().setDelay(5L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return RequestScopeEventMessageDeliveryTest.this.observer.isDestroyedCalled();
            }
        }).start();
        Assert.assertTrue((boolean)this.observer.isDestroyedCalled());
    }
}

