/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.builtin.event;

import java.lang.annotation.Annotation;
import java.util.Collections;
import javax.enterprise.event.Event;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.decorators.AbstractDecoratorTest;
import org.jboss.cdi.tck.tests.decorators.builtin.event.CharSequenceEventDecorator;
import org.jboss.cdi.tck.tests.decorators.builtin.event.Foo;
import org.jboss.cdi.tck.tests.decorators.builtin.event.FooEventDecorator;
import org.jboss.cdi.tck.tests.decorators.builtin.event.Observer;
import org.jboss.cdi.tck.tests.decorators.builtin.event.StringEventDecorator;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class BuiltinEventDecoratorTest
extends AbstractDecoratorTest {
    @Inject
    Observer observer;
    @Inject
    Event<Foo> fooEvent;
    @Inject
    private Event<String> stringEvent;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinEventDecoratorTest.class)).withClass(AbstractDecoratorTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateDecorators().clazz(new String[]{FooEventDecorator.class.getName()}).clazz(new String[]{StringEventDecorator.class.getName()}).clazz(new String[]{CharSequenceEventDecorator.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_invocation", id="aca"), @SpecAssertion(section="decorator_resolution", id="aa")})
    public void testDecoratorIsResolved() {
        TypeLiteral<Event<Foo>> eventFooLiteral = new TypeLiteral<Event<Foo>>(){};
        this.checkDecorator(this.resolveUniqueDecorator(Collections.singleton(eventFooLiteral.getType()), new Annotation[0]), FooEventDecorator.class, Collections.singleton(eventFooLiteral.getType()), eventFooLiteral.getType());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_invocation", id="aca")})
    public void testDecoratorIsInvoked() {
        Foo payload = new Foo(false);
        this.fooEvent.fire((Object)payload);
        Assert.assertTrue((boolean)this.observer.isObserved());
        Assert.assertTrue((boolean)payload.isDecorated());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_invocation", id="aca")})
    public void testMultipleDecorators() {
        this.stringEvent.fire((Object)"TCK");
        Assert.assertEquals((String)this.observer.getString(), (String)"DecoratedCharSequenceDecoratedStringTCK");
        try {
            this.stringEvent.select(new Annotation[0]);
            Assert.fail((String)"Exception not thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

