/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.resolve.AirConditioner;
import org.jboss.cdi.tck.tests.event.observer.resolve.BatteryEvent;
import org.jboss.cdi.tck.tests.event.observer.resolve.DiskSpaceEvent;
import org.jboss.cdi.tck.tests.event.observer.resolve.Ghost;
import org.jboss.cdi.tck.tests.event.observer.resolve.MultiBindingEvent;
import org.jboss.cdi.tck.tests.event.observer.resolve.RoleBinding;
import org.jboss.cdi.tck.tests.event.observer.resolve.Secret;
import org.jboss.cdi.tck.tests.event.observer.resolve.SimpleEventType;
import org.jboss.cdi.tck.tests.event.observer.resolve.TameAnnotationLiteral;
import org.jboss.cdi.tck.tests.event.observer.resolve.Temperature;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class ResolveEventObserversTest
extends AbstractTest {
    private static final String BEAN_MANAGER_RESOLVE_OBSERVERS_METHOD_NAME = "resolveObserverMethods";

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ResolveEventObserversTest.class)).build();
    }

    @Test
    @SpecAssertion(section="observer_methods", id="e")
    public void testMultipleObserverMethodsForSameEventPermissible() {
        assert (this.getCurrentManager().resolveObserverMethods((Object)new DiskSpaceEvent(), new Annotation[0]).size() == 2);
    }

    @Test
    @SpecAssertion(section="observer_methods", id="f")
    public void testMultipleObserverMethodsOnBeanPermissible() {
        assert (this.getCurrentManager().resolveObserverMethods((Object)new BatteryEvent(), new Annotation[0]).size() == 1);
        assert (this.getCurrentManager().resolveObserverMethods((Object)new DiskSpaceEvent(), new Annotation[0]).size() == 2);
    }

    @Test
    @SpecAssertion(section="observes", id="a")
    public void testMethodWithParameterAnnotatedWithObservesRegistersObserverMethod() throws SecurityException, NoSuchMethodException {
        Set temperatureObservers = this.getCurrentManager().resolveObserverMethods((Object)new Temperature(0.0), new Annotation[0]);
        assert (temperatureObservers.size() == 1);
        ObserverMethod temperatureObserver = (ObserverMethod)temperatureObservers.iterator().next();
        assert (temperatureObserver.getBeanClass().equals(AirConditioner.class));
        assert (temperatureObserver.getObservedType().equals(Temperature.class));
        Method method = AirConditioner.class.getMethod("temperatureChanged", Temperature.class);
        assert (method != null);
        assert (method.getParameterTypes().length == 1);
        assert (method.getParameterTypes()[0].equals(Temperature.class));
        assert (method.getParameterAnnotations()[0][0].annotationType().equals(Observes.class));
    }

    @Test
    @SpecAssertion(section="observer_method_event_parameter", id="b")
    public void testObserverMethodWithoutBindingTypesObservesEventsWithoutBindingTypes() {
        assert (this.getCurrentManager().resolveObserverMethods((Object)new SimpleEventType(), new Annotation[0]).size() == 2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observes", id="c"), @SpecAssertion(section="event_qualifier_types_with_members", id="a"), @SpecAssertion(section="multiple_event_qualifiers", id="a")})
    public void testObserverMethodMayHaveMultipleBindingTypes() {
        assert (this.getCurrentManager().resolveObserverMethods((Object)new MultiBindingEvent(), new Annotation[]{new RoleBinding("Admin"), new TameAnnotationLiteral()}).size() == 2);
    }

    @Test
    @SpecAssertion(section="observer_notification", id="aa")
    public void testObserverMethodRegistration() {
        assert (this.getCurrentManager().resolveObserverMethods((Object)new SimpleEventType(), new Annotation[0]).size() == 2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_observer_method_resolution", id="a"), @SpecAssertion(section="bm_observer_method_resolution", id="b")})
    public void testBeanManagerResolveObserversSignature() throws Exception {
        assert (this.getCurrentManager().getClass().getDeclaredMethod(BEAN_MANAGER_RESOLVE_OBSERVERS_METHOD_NAME, Object.class, Annotation[].class) != null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_observer_method_resolution", id="e")
    public void testBeanManagerResolveObserversWithIllegalQualifier() {
        this.getCurrentManager().resolveObserverMethods((Object)new SimpleEventType(), new Annotation[]{new AnnotationLiteral<Override>(){}});
    }

    @Test
    @SpecAssertion(section="bean_discovery", id="o")
    public void testObserverMethodAutomaticallyRegistered() {
        assert (!this.getCurrentManager().resolveObserverMethods((Object)new String(), new Annotation[]{new AnnotationLiteral<Secret>(){}}).isEmpty());
    }

    @Test
    @SpecAssertion(section="bean_discovery", id="o")
    public void testObserverMethodNotAutomaticallyRegisteredForDisabledBeans() {
        Set ghostObservers = this.getCurrentManager().resolveObserverMethods((Object)new Ghost(), new Annotation[0]);
        assert (ghostObservers.size() == 0);
        Set stringObservers = this.getCurrentManager().resolveObserverMethods((Object)new String(), new Annotation[]{new AnnotationLiteral<Secret>(){}});
        assert (stringObservers.size() == 1);
        for (ObserverMethod observer : stringObservers) {
            observer.notify((Object)"fail if disabled observer invoked");
        }
    }
}

