/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class TransformationUtils {
    public static <F, T> List<T> transform(Function<? super F, T> function, Collection<F> fromCollection) {
        TransformationUtils.checkNotNull(fromCollection);
        TransformationUtils.checkNotNull(function);
        ArrayList<T> result = new ArrayList<T>(fromCollection.size());
        for (F element : fromCollection) {
            result.add(function.apply(element));
        }
        return result;
    }

    @SafeVarargs
    public static <F, T> List<T> transform(Function<? super F, T> function, F ... inputElements) {
        return TransformationUtils.transform(function, Arrays.asList(inputElements));
    }

    private static void checkNotNull(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null argument.");
        }
    }

    public static interface Function<F, T> {
        public T apply(F var1);
    }
}

