/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.jms;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.descriptors.ejb.EjbJarDescriptorBuilder;
import org.jboss.cdi.tck.tests.context.jms.AbstractMessageListener;
import org.jboss.cdi.tck.tests.context.jms.LogStore;
import org.jboss.cdi.tck.tests.context.jms.QueueMessageDrivenBean;
import org.jboss.cdi.tck.tests.context.jms.SimpleMessageProducer;
import org.jboss.cdi.tck.tests.context.jms.TopicMessageDrivenBean;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.ejbjar31.EjbJarDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class MessageDrivenBeanContextTest
extends AbstractTest {
    @Inject
    SimpleMessageProducer producer;
    @Inject
    LogStore store;

    @Deployment
    public static WebArchive createTestArchive() {
        EjbJarDescriptor ejbJarDescriptor = new EjbJarDescriptorBuilder().messageDrivenBeans(EjbJarDescriptorBuilder.MessageDriven.newMessageDriven("TestQueue", QueueMessageDrivenBean.class.getName()).addActivationConfigProperty("acknowledgeMode", "Auto-acknowledge").addActivationConfigProperty("destinationType", "javax.jms.Queue").addActivationConfigProperty("destinationLookup", ConfigurationFactory.get().getTestJmsQueue()), EjbJarDescriptorBuilder.MessageDriven.newMessageDriven("TestTopic", TopicMessageDrivenBean.class.getName()).addActivationConfigProperty("acknowledgeMode", "Auto-acknowledge").addActivationConfigProperty("destinationType", "javax.jms.Topic").addActivationConfigProperty("destinationLookup", ConfigurationFactory.get().getTestJmsTopic())).build();
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MessageDrivenBeanContextTest.class)).withEjbJarXml(ejbJarDescriptor)).build();
    }

    @Test(groups={"javaee-full", "jms"})
    @SpecAssertions(value={@SpecAssertion(section="request_context", id="gd"), @SpecAssertion(section="request_context", id="hd"), @SpecAssertion(section="application_context", id="dd")})
    public void testRequestScopeActiveDuringMessageDelivery() throws Exception {
        AbstractMessageListener.resetProcessedMessages();
        this.producer.sendQueueMessage();
        this.producer.sendTopicMessage();
        new Timer().setDelay(5L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return AbstractMessageListener.processedMessages.get() >= 2;
            }
        }).start();
        List<LogStore.LogMessage> logMessages = this.store.getLogMessages();
        Assert.assertEquals((int)logMessages.size(), (int)2);
        LogStore.LogMessage msg1 = logMessages.get(0);
        Assert.assertEquals((String)msg1.getText(), (String)SimpleMessageProducer.class.getName());
        LogStore.LogMessage msg2 = logMessages.get(1);
        Assert.assertEquals((String)msg2.getText(), (String)SimpleMessageProducer.class.getName());
        Assert.assertFalse((boolean)msg1.getServiceId().equals(msg2.getServiceId()));
    }
}

