/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.impl.testng;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jboss.cdi.tck.api.Configuration;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class ConfigurationLoggingListener
implements ISuiteListener {
    private static final String CONFIGURATION_FILE_PATH = "target/cdi-tck-configuration.log";
    private final Logger logger = Logger.getLogger(ConfigurationLoggingListener.class.getName());

    public void onStart(ISuite suite) {
        try {
            FileHandler fh = new FileHandler(CONFIGURATION_FILE_PATH);
            fh.setFormatter(new SimpleFormatter());
            this.logger.addHandler(fh);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.log(Level.INFO, "CDI-TCK Implementation version: {0}", Package.getPackage("org.jboss.cdi.tck.impl.testng").getImplementationVersion());
        this.logger.log(Level.INFO, "CDI-TCK Specification version: {0}", Package.getPackage("org.jboss.cdi.tck.impl.testng").getSpecificationVersion());
        Configuration conf = ConfigurationFactory.get();
        this.logger.log(Level.INFO, conf.toString());
    }

    public void onFinish(ISuite suite) {
    }
}

